/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import edu.colorado.phet.common.phetcommon.view.ClockControlPanel;
import edu.colorado.phet.common.phetcommon.view.TimeControlPanel;
import edu.colorado.phet.common.timeseries.ui.TimeSpeedSlider;
import edu.colorado.phet.energyskatepark.EnergySkateParkApplication;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnergySkateParkTimePanel
extends JPanel {
    private EnergySkateParkModule module;

    public EnergySkateParkTimePanel(final EnergySkateParkModule energySkateParkModule, final Clock clock) {
        this.module = energySkateParkModule;
        final TimeSpeedSlider timeSpeedSlider = new TimeSpeedSlider(EnergySkateParkApplication.SIMULATION_TIME_DT / 4.0, EnergySkateParkApplication.SIMULATION_TIME_DT, "0.00", (ConstantDtClock)clock);
        timeSpeedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                clock.setTimingStrategy(new TimingStrategy.Constant(timeSpeedSlider.getValue()));
            }
        });
        this.add(timeSpeedSlider);
        ClockControlPanel clockControlPanel = new ClockControlPanel(clock);
        clockControlPanel.addTimeControlListener(new TimeControlPanel.TimeControlAdapter(){

            public void stepPressed() {
                energySkateParkModule.setRecordOrLiveMode();
            }

            public void playPressed() {
                energySkateParkModule.setRecordOrLiveMode();
            }

            public void pausePressed() {
                energySkateParkModule.setRecordOrLiveMode();
            }
        });
        this.add(clockControlPanel);
    }
}

