/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.energyskatepark.EnergySkateParkApplication;
import edu.colorado.phet.energyskatepark.serialization.EnergySkateParkIO;
import edu.colorado.phet.energyskatepark.view.swing.EnergySkateParkTestMenu;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class EnergySkateParkTrackMenu
extends JMenu {
    private EnergySkateParkApplication parentApp;

    public EnergySkateParkTrackMenu(EnergySkateParkApplication energySkateParkApplication) {
        this("Tracks", energySkateParkApplication, EnergySkateParkTrackMenu.getTests());
    }

    public EnergySkateParkTrackMenu(String string, final EnergySkateParkApplication energySkateParkApplication, EnergySkateParkTestMenu.TestItem[] testItemArray) {
        super(string);
        this.parentApp = energySkateParkApplication;
        for (int i = 0; i < testItemArray.length; ++i) {
            final EnergySkateParkTestMenu.TestItem testItem = testItemArray[i];
            this.add(new JMenuItem(new AbstractAction(testItem.getTitle()){

                public void actionPerformed(ActionEvent actionEvent) {
                    EnergySkateParkIO.open(testItem.getLocation(), energySkateParkApplication.getModule());
                }
            }));
        }
    }

    private static EnergySkateParkTestMenu.TestItem[] getTests() {
        return new EnergySkateParkTestMenu.TestItem[]{new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/loop.esp", "Loop"), new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/double-well.esp", "Double Well"), new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/double-well-rc.esp", "Double Well (Roller Coaster)"), new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/fallthrough_test.esp", "Friction Parabola"), new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/jump.esp", "Jump"), new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/strack4.esp", "S-Curve"), new EnergySkateParkTestMenu.TestItem("energy-skate-park/tests/fly-off.esp", "Fly Off (bug)")};
    }
}

