/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FrictionControl
extends VerticalLayoutPanel {
    private ModelSlider modelSlider = new ModelSlider(EnergySkateParkStrings.getString("controls.friction"), "", 0.0, 0.01, 0.0, new DecimalFormat("0.000"), new DecimalFormat("0.000"));

    public FrictionControl(final EnergySkateParkModule energySkateParkModule) {
        this.modelSlider.setModelTicks(new double[]{0.0, 0.005, 0.01});
        this.modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                energySkateParkModule.setCoefficientOfFriction(FrictionControl.this.modelSlider.getValue());
            }
        });
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                if (energySkateParkModule.getEnergySkateParkModel().getNumBodies() > 0) {
                    FrictionControl.this.modelSlider.setValue(energySkateParkModule.getEnergySkateParkModel().getBody(0).getFrictionCoefficient());
                }
            }
        });
        this.modelSlider.setTextFieldVisible(false);
        this.setIgnoreKeyEvents(true);
        this.modelSlider.setExtremumLabels(new JLabel(EnergySkateParkStrings.getString("controls.gravity.none")), new JLabel(EnergySkateParkStrings.getString("controls.gravity.lots")));
        this.addFullWidth(this.modelSlider);
    }

    private void setIgnoreKeyEvents(boolean bl) {
        this.setFocusable(!bl);
    }

    public ModelSlider getModelSlider() {
        return this.modelSlider;
    }
}

