/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GravitySlider
extends LinearValueControl {
    private EnergySkateParkModule module;

    public GravitySlider(final EnergySkateParkModule energySkateParkModule) {
        super(0.0, 30.0, EnergySkateParkStrings.getString("controls.gravity"), "0.00", EnergySkateParkStrings.getString("units.accel"));
        this.module = energySkateParkModule;
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(0.0), new JLabel(EnergySkateParkStrings.getString("location.space")));
        hashtable.put(new Double(9.81), new JLabel(EnergySkateParkStrings.getString("location.earth")));
        hashtable.put(new Double(25.95), new JLabel(EnergySkateParkStrings.getString("location.jupiter")));
        this.setMajorTickSpacing(10.0);
        this.setMinorTickSpacing(5.0);
        this.setTickLabels(hashtable);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                energySkateParkModule.getEnergySkateParkModel().setGravity(-GravitySlider.this.getValue());
            }
        });
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void gravityChanged() {
                GravitySlider.this.update();
            }
        });
        this.setFocusable(false);
        this.getSlider().setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.update();
    }

    private void update() {
        this.setValue(Math.abs(this.module.getEnergySkateParkModel().getGravity()));
    }
}

