/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class PathRecordContol
extends HorizontalLayoutPanel {
    private JButton recordPath;
    private JButton clearHistory;
    private EnergySkateParkModule module;
    private boolean recording = false;

    public PathRecordContol(final EnergySkateParkModule energySkateParkModule) {
        this.module = energySkateParkModule;
        this.setBorder(BorderFactory.createTitledBorder(EnergySkateParkStrings.getString("controls.path")));
        this.recordPath = new JButton(EnergySkateParkStrings.getString("controls.record-path"));
        this.recordPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PathRecordContol.this.setRecording(!PathRecordContol.this.recording);
            }
        });
        this.clearHistory = new JButton(EnergySkateParkStrings.getString("time.clear"));
        this.clearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.clearPaths();
                if (!PathRecordContol.this.recording) {
                    PathRecordContol.this.clearHistory.setEnabled(false);
                }
            }
        });
        this.clearHistory.setEnabled(false);
        this.setFill(0);
        this.setAnchor(17);
        this.add(this.recordPath);
        this.setAnchor(13);
        this.add(this.clearHistory);
        this.updateButtons();
    }

    private void updateButtons() {
        this.recordPath.setText(this.recording ? EnergySkateParkStrings.getString("controls.stop-recording-path") : EnergySkateParkStrings.getString("controls.record-path"));
        this.clearHistory.setEnabled(this.module.getEnergySkateParkModel().getNumHistoryPoints() > 0);
    }

    public void reset() {
        this.setRecording(false);
    }

    private void setRecording(boolean bl) {
        this.recording = bl;
        this.module.setRecordPath(this.recording);
        this.updateButtons();
    }
}

