/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.energyskatepark.view.swing;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.energyskatepark.EnergySkateParkModule;
import edu.colorado.phet.energyskatepark.EnergySkateParkStrings;
import edu.colorado.phet.energyskatepark.model.EnergySkateParkModel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkControlPanel;
import edu.colorado.phet.energyskatepark.view.EnergySkateParkSimulationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PieChartControlPanel
extends HorizontalLayoutPanel {
    private EnergySkateParkModule module;
    private EnergySkateParkControlPanel energySkateParkControlPanel;
    private JCheckBox showThermal;
    private JCheckBox showPieChartCheckBox;

    public PieChartControlPanel(final EnergySkateParkModule energySkateParkModule, EnergySkateParkControlPanel energySkateParkControlPanel) {
        this.module = energySkateParkModule;
        this.energySkateParkControlPanel = energySkateParkControlPanel;
        this.showPieChartCheckBox = new JCheckBox(EnergySkateParkStrings.getString("piechart.show"), energySkateParkModule.isPieChartVisible());
        this.showPieChartCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PieChartControlPanel.this.updateShowThermalEnabled();
                energySkateParkModule.setPieChartVisible(PieChartControlPanel.this.showPieChartCheckBox.isSelected());
            }
        });
        this.add(this.showPieChartCheckBox);
        this.showThermal = new JCheckBox(EnergySkateParkStrings.getString("piechart.show-thermal"), !energySkateParkModule.getEnergySkateParkSimulationPanel().getRootNode().getIgnoreThermal());
        this.showThermal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                energySkateParkModule.getEnergySkateParkSimulationPanel().setIgnoreThermal(!PieChartControlPanel.this.showThermal.isSelected());
            }
        });
        energySkateParkModule.getEnergySkateParkSimulationPanel().addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void ignoreThermalChanged() {
                PieChartControlPanel.this.showThermal.setSelected(!energySkateParkModule.getEnergySkateParkSimulationPanel().getIgnoreThermal());
            }
        });
        this.add(this.showThermal);
        energySkateParkModule.getEnergySkateParkModel().addEnergyModelListener(new EnergySkateParkModel.EnergyModelListenerAdapter(){

            public void primaryBodyChanged() {
                PieChartControlPanel.this.update();
            }
        });
        energySkateParkModule.getEnergySkateParkSimulationPanel().addListener(new EnergySkateParkSimulationPanel.Adapter(){

            public void pieChartVisibilityChanged() {
                PieChartControlPanel.this.showPieChartCheckBox.setSelected(energySkateParkModule.isPieChartVisible());
            }
        });
        this.setAnchor(17);
        this.updateShowThermalEnabled();
        this.showPieChartCheckBox.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PieChartControlPanel.this.updateShowThermalEnabled();
            }
        });
        this.showPieChartCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PieChartControlPanel.this.updateShowThermalEnabled();
            }
        });
    }

    private void updateShowThermalEnabled() {
        this.showThermal.setEnabled(this.showPieChartCheckBox.isEnabled() && this.showPieChartCheckBox.isSelected());
    }

    private void update() {
        EnergySkateParkModel energySkateParkModel = this.module.getEnergySkateParkModel();
        boolean bl = energySkateParkModel.getNumBodies() > 0 && energySkateParkModel.getBody(0).getPotentialEnergy() >= 0.0;
        this.showPieChartCheckBox.setEnabled(bl);
    }
}

