/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.geom.AffineTransform;

public class PTransformActivity
extends PInterpolatingActivity {
    private static PAffineTransform STATIC_TRANSFORM = new PAffineTransform();
    private double[] source = new double[6];
    private double[] destination = new double[6];
    private Target target;

    public PTransformActivity(long l, long l2, Target target, AffineTransform affineTransform) {
        this(l, l2, 1, 1, target, affineTransform);
    }

    public PTransformActivity(long l, long l2, int n, int n2, Target target, AffineTransform affineTransform) {
        super(l, l2, n, n2);
        this.target = target;
        if (affineTransform != null) {
            affineTransform.getMatrix(this.destination);
        }
    }

    protected boolean isAnimation() {
        return true;
    }

    protected void activityStarted() {
        if (this.getFirstLoop()) {
            this.target.getSourceMatrix(this.source);
        }
        super.activityStarted();
    }

    public void setRelativeTargetValue(float f) {
        super.setRelativeTargetValue(f);
        STATIC_TRANSFORM.setTransform(this.source[0] + (double)f * (this.destination[0] - this.source[0]), this.source[1] + (double)f * (this.destination[1] - this.source[1]), this.source[2] + (double)f * (this.destination[2] - this.source[2]), this.source[3] + (double)f * (this.destination[3] - this.source[3]), this.source[4] + (double)f * (this.destination[4] - this.source[4]), this.source[5] + (double)f * (this.destination[5] - this.source[5]));
        this.target.setTransform(STATIC_TRANSFORM);
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("source=" + (this.source == null ? "null" : this.source.toString()));
        stringBuffer.append(",destination=" + (this.destination == null ? "null" : this.destination.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }

    public static interface Target {
        public void setTransform(AffineTransform var1);

        public void getSourceMatrix(double[] var1);
    }
}

