/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.math;

public interface Function {
    public double evaluate(double var1);

    public static class LinearFunction
    implements Function {
        private double minInput;
        private double maxInput;
        private double minOutput;
        private double maxOutput;
        private double t1;
        private double scale;
        private double t2;

        public LinearFunction(double d, double d2, double d3, double d4) {
            this.minInput = d;
            this.maxInput = d2;
            this.minOutput = d3;
            this.maxOutput = d4;
            this.update();
        }

        protected void update() {
            this.t1 = -this.minInput;
            this.scale = (this.maxOutput - this.minOutput) / (this.maxInput - this.minInput);
            this.t2 = this.minOutput;
        }

        public double evaluate(double d) {
            double d2 = this.t1 + d;
            d2 = this.scale * d2;
            d2 = this.t2 + d2;
            return d2;
        }

        public Function createInverse() {
            return new LinearFunction(this.minOutput, this.maxOutput, this.minInput, this.maxInput);
        }

        public void setOutput(double d, double d2) {
            this.minOutput = d;
            this.maxOutput = d2;
            this.update();
        }

        public String toString() {
            return "Linear Function, [" + this.minInput + "," + this.maxInput + "]->[" + this.minOutput + "," + this.maxOutput + "]";
        }
    }
}

