/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.model.clock;

import edu.colorado.phet.common_force1d.model.clock.ClockStateEvent;
import edu.colorado.phet.common_force1d.model.clock.ClockStateListener;
import edu.colorado.phet.common_force1d.model.clock.ClockTickEvent;
import edu.colorado.phet.common_force1d.model.clock.ClockTickListener;
import edu.colorado.phet.common_force1d.model.clock.CompositeClockTickListener;
import edu.colorado.phet.common_force1d.util.EventChannel;

public abstract class AbstractClock {
    private double runningTime;
    private TickConverter tickConverter;
    private int delay;
    private int executionState = 1;
    private double dt;
    private EventChannel clockStateEventChannel = new EventChannel(ClockStateListener.class);
    private ClockStateListener clockStateListenerProxy = (ClockStateListener)this.clockStateEventChannel.getListenerProxy();
    private CompositeClockTickListener tickHandler = new CompositeClockTickListener();

    public AbstractClock(double d, int n, boolean bl) {
        this.tickConverter = bl ? new Static() : new TimeScaling();
        this.delay = n;
        this.dt = d;
    }

    public boolean isRunning() {
        return this.executionState == 1;
    }

    public boolean isPaused() {
        return this.executionState == 2;
    }

    public double getRunningTime() {
        return this.runningTime;
    }

    public synchronized void start() {
        if (this.executionState != 1 && this.executionState != 3) {
            throw new RuntimeException("Clock cannot be started twice.");
        }
        this.doStart();
        this.setRunningTime(0.0);
        this.executionState = 1;
    }

    public void setPaused(boolean bl) {
        if (bl) {
            if (this.executionState == 1) {
                this.executionState = 2;
                this.doPause();
            }
        } else if (this.executionState == 2) {
            this.executionState = 1;
            this.doUnpause();
        }
        this.clockStateListenerProxy.stateChanged(new ClockStateEvent(this));
    }

    public void tickOnce() {
        this.clockTicked(this.getSimulationTime(this.delay));
    }

    protected abstract void doPause();

    protected abstract void doUnpause();

    protected abstract void doStart();

    protected void clockTicked(double d) {
        this.runningTime += d;
        ClockTickEvent clockTickEvent = new ClockTickEvent(this, d);
        this.tickHandler.clockTicked(clockTickEvent);
    }

    public String toString() {
        return this.getClass().getName() + ", time=" + this.getRunningTime();
    }

    protected void setRunningTime(double d) {
        this.runningTime = d;
    }

    protected double getSimulationTime(long l) {
        return this.tickConverter.getSimulationTime(l);
    }

    public void removeClockTickListener(ClockTickListener clockTickListener) {
        this.tickHandler.removeClockTickListener(clockTickListener);
    }

    public void addClockTickListener(ClockTickListener clockTickListener) {
        this.tickHandler.addClockTickListener(clockTickListener);
    }

    public void addClockStateListener(ClockStateListener clockStateListener) {
        this.clockStateEventChannel.addListener(clockStateListener);
    }

    public boolean containsClockTickListener(ClockTickListener clockTickListener) {
        return this.tickHandler.containsClockTickListener(clockTickListener);
    }

    public class TimeScaling
    implements TickConverter {
        public double getSimulationTime(long l) {
            return AbstractClock.this.dt / (double)AbstractClock.this.delay * (double)l;
        }
    }

    public class Static
    implements TickConverter {
        public double getSimulationTime(long l) {
            return AbstractClock.this.dt;
        }
    }

    public static interface TickConverter {
        public double getSimulationTime(long var1);
    }
}

