/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultiMap
implements Map {
    private long lastModified = 0L;
    private TreeMap map = new TreeMap();

    public Object put(Object object, Object object2) {
        Object object3 = this.map.get(object);
        ArrayList<Object> arrayList = (ArrayList<Object>)object3;
        this.lastModified = System.currentTimeMillis();
        if (object3 == null) {
            arrayList = new ArrayList<Object>();
            this.map.put(object, arrayList);
            object3 = arrayList;
        }
        arrayList.add(object2);
        return object3;
    }

    public void putAll(Map map) {
        ++this.lastModified;
        map.putAll(map);
    }

    public boolean containsValue(Object object) {
        boolean bl = false;
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext() && !bl) {
            bl = ((ArrayList)iterator.next()).contains(object);
        }
        return bl;
    }

    public void clear() {
        ++this.lastModified;
        this.map.clear();
    }

    public Object remove(Object object) {
        ++this.lastModified;
        return this.map.remove(object);
    }

    public void removeValue(Object object) {
        while (this.containsValue(object)) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(object)) continue;
                iterator.remove();
                break;
            }
            ++this.lastModified;
        }
    }

    public Iterator iterator() {
        return new ForwardIterator();
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List list = (List)entry.getValue();
            n += list.size();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public Collection values() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List list = (List)entry.getValue();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public Set entrySet() {
        throw new RuntimeException("not implemented");
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public String toString() {
        return this.map.toString();
    }

    private class ForwardIterator
    extends MultiMapIterator {
        private Iterator mapIterator;
        private Iterator listIterator;
        private ArrayList currentList;

        ForwardIterator() {
            this.mapIterator = MultiMap.this.map.entrySet().iterator();
            if (this.mapIterator.hasNext()) {
                this.nextListIterator();
            }
        }

        public boolean hasNext() {
            this.concurrentModificationCheck();
            if (this.mapIterator.hasNext()) {
                return true;
            }
            if (this.listIterator != null) {
                return this.listIterator.hasNext();
            }
            return false;
        }

        public Object next() {
            this.concurrentModificationCheck();
            if (this.listIterator.hasNext()) {
                return this.listIterator.next();
            }
            if (this.mapIterator.hasNext()) {
                this.nextListIterator();
                return this.next();
            }
            return null;
        }

        public void remove() {
            this.concurrentModificationCheck();
            this.listIterator.remove();
            if (this.currentList.size() == 0) {
                this.mapIterator.remove();
            }
            MultiMap.this.lastModified++;
        }

        private void nextListIterator() {
            this.currentList = (ArrayList)((Map.Entry)this.mapIterator.next()).getValue();
            this.listIterator = this.currentList.iterator();
        }
    }

    private abstract class MultiMapIterator
    implements Iterator {
        protected long timeCreated;

        public MultiMapIterator() {
            this.timeCreated = MultiMap.this.lastModified;
        }

        protected void concurrentModificationCheck() {
            if (this.timeCreated < MultiMap.this.lastModified) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

