/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view;

import edu.colorado.phet.common_force1d.model.clock.AbstractClock;
import edu.colorado.phet.common_force1d.view.GraphicsSetup;
import edu.colorado.phet.common_force1d.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.RepaintDebugGraphic;
import edu.colorado.phet.common_force1d.view.util.GraphicsState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class ApparatusPanel
extends JPanel {
    private BasicStroke borderStroke = new BasicStroke(1.0f, 1, 1);
    private GraphicLayerSet graphic;
    private ArrayList graphicsSetups = new ArrayList();
    private boolean displayBorder = true;

    protected ApparatusPanel(Object object) {
        super(null);
        this.graphic = new GraphicLayerSet(this);
    }

    public ApparatusPanel() {
        super(null);
        this.setGraphic(new GraphicLayerSet(this));
    }

    public void setGraphic(GraphicLayerSet graphicLayerSet) {
        Object object;
        this.graphic = graphicLayerSet;
        this.graphic.setComponent(this);
        Iterator iterator = this.graphic.getGraphicMap().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof PhetGraphic)) continue;
            PhetGraphic phetGraphic = (PhetGraphic)object;
            phetGraphic.setComponent(this);
        }
        object = this.getMouseListeners();
        for (int i = 0; i < ((E)object).length; ++i) {
            Object e = object[i];
            this.removeMouseListener((MouseListener)e);
        }
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            MouseMotionListener mouseMotionListener = mouseMotionListenerArray[i];
            this.removeMouseMotionListener(mouseMotionListener);
        }
        KeyListener[] keyListenerArray = this.getKeyListeners();
        for (int i = 0; i < keyListenerArray.length; ++i) {
            KeyListener keyListener = keyListenerArray[i];
            this.removeKeyListener(keyListener);
        }
        this.addMouseListener(graphicLayerSet.getMouseHandler());
        this.addMouseMotionListener(graphicLayerSet.getMouseHandler());
        this.addKeyListener(graphicLayerSet.getKeyAdapter());
    }

    public void addGraphicsSetup(GraphicsSetup graphicsSetup) {
        this.graphicsSetups.add(graphicsSetup);
    }

    public void addRepaintDebugGraphic(AbstractClock abstractClock) {
        final RepaintDebugGraphic repaintDebugGraphic = new RepaintDebugGraphic(this, abstractClock);
        this.addGraphic(repaintDebugGraphic, Double.POSITIVE_INFINITY);
        repaintDebugGraphic.setActive(false);
        repaintDebugGraphic.setVisible(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ApparatusPanel.this.requestFocus();
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 80) {
                    repaintDebugGraphic.setActive(!repaintDebugGraphic.isActive());
                    repaintDebugGraphic.setVisible(repaintDebugGraphic.isActive());
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.requestFocus();
    }

    protected void setup(Graphics2D graphics2D) {
        for (int i = 0; i < this.graphicsSetups.size(); ++i) {
            GraphicsSetup graphicsSetup = (GraphicsSetup)this.graphicsSetups.get(i);
            graphicsSetup.setup(graphics2D);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        this.setup(graphics2D);
        this.graphic.paint(graphics2D);
        this.drawBorder(graphics2D);
        graphicsState.restoreGraphics();
    }

    public void paint() {
        this.repaint();
    }

    public void addGraphic(PhetGraphic phetGraphic, double d) {
        this.graphic.addGraphic(phetGraphic, d);
    }

    public void addGraphic(PhetGraphic phetGraphic) {
        this.addGraphic(phetGraphic, 0.0);
    }

    public void removeGraphic(PhetGraphic phetGraphic) {
        this.graphic.removeGraphic(phetGraphic);
    }

    public GraphicLayerSet getGraphic() {
        return this.graphic;
    }

    protected void drawBorder(Graphics2D graphics2D) {
        if (this.displayBorder) {
            GraphicsState graphicsState = new GraphicsState(graphics2D);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(this.borderStroke);
            Rectangle rectangle = new Rectangle(0, 0, (int)this.getBounds().getWidth() - 1, (int)this.getBounds().getHeight() - 1);
            graphics2D.draw(rectangle);
            graphicsState.restoreGraphics();
        }
    }

    public void handleUserInput() {
    }
}

