/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common_force1d.application.Module;
import edu.colorado.phet.common_force1d.view.components.VerticalLayoutPanel;
import edu.colorado.phet.common_force1d.view.help.HelpPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;

public class ControlPanel
extends JPanel {
    private ContentPanel controlPane = new ContentPanel();
    private ImageIcon imageIcon;
    private JLabel titleLabel;
    private JScrollPane verticalScrollPane;
    private HelpPanel helpPanel;
    private JPanel northPanel;
    private int paddingDY = 5;
    private JScrollPane horizontalScrollPane;

    public ContentPanel getControlPane() {
        return this.controlPane;
    }

    public ControlPanel(Module module) {
        this.setLayout(new Layout());
        this.imageIcon = new ImageIcon(PhetCommonResources.getInstance().getImage("logos/phet-logo.jpg"));
        this.titleLabel = new JLabel(this.imageIcon);
        this.northPanel = new JPanel();
        this.northPanel.add(this.titleLabel);
        this.addToPanel(this.northPanel);
        this.verticalScrollPane = new JScrollPane(22, 31);
        this.verticalScrollPane.setBorder(this.createBorder());
        this.horizontalScrollPane = new JScrollPane(21, 32);
        this.horizontalScrollPane.setBorder(this.createBorder());
        this.helpPanel = new HelpPanel(module);
        this.addToPanel(this.helpPanel);
        this.setHelpPanelEnabled(module.hasHelp());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ControlPanel.this.relayoutControlPanel();
            }

            public void componentShown(ComponentEvent componentEvent) {
                ControlPanel.this.relayoutControlPanel();
            }
        });
        this.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                ControlPanel.this.relayoutControlPanel();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ControlPanel.this.relayoutControlPanel();
            }
        });
        this.relayoutControlPanel();
    }

    private EtchedBorder createBorder() {
        return new EtchedBorder(new Color(220, 200, 255), Color.gray);
    }

    private void addToPanel(Component component) {
        super.add(component);
    }

    public Component add(Component component) {
        return this.addControl(component);
    }

    public void removeTitle() {
        this.northPanel.remove(this.titleLabel);
    }

    public void setHelpPanelEnabled(boolean bl) {
        this.helpPanel.setVisible(bl);
    }

    public Component addControl(Component component) {
        return this.controlPane.add(component);
    }

    public void addControlFullWidth(JComponent jComponent) {
        this.controlPane.addFullWidth(jComponent);
    }

    private void relayoutControlPanel() {
        this.revalidate();
        this.repaint();
    }

    public void setHelpEnabled(boolean bl) {
        this.helpPanel.setHelpEnabled(bl);
    }

    public class ContentPanel
    extends VerticalLayoutPanel {
        public ContentPanel() {
            this.setFill(0);
        }
    }

    public class Layout
    implements LayoutManager {
        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            ControlPanel.this.northPanel.setBounds(this.getPositionToCenter(ControlPanel.this.northPanel), 0, ((ControlPanel)ControlPanel.this).northPanel.getPreferredSize().width, ((ControlPanel)ControlPanel.this).northPanel.getPreferredSize().height);
            ControlPanel.this.helpPanel.setBounds(this.getPositionToCenter(ControlPanel.this.helpPanel), ControlPanel.this.getHeight() - ((ControlPanel)ControlPanel.this).helpPanel.getPreferredSize().height, ((ControlPanel)ControlPanel.this).helpPanel.getPreferredSize().width, ((ControlPanel)ControlPanel.this).helpPanel.getPreferredSize().height);
            ControlPanel.this.remove(ControlPanel.this.verticalScrollPane);
            ControlPanel.this.remove(ControlPanel.this.horizontalScrollPane);
            ControlPanel.this.remove(ControlPanel.this.controlPane);
            ControlPanel.this.verticalScrollPane.setViewportView(null);
            ControlPanel.this.horizontalScrollPane.setViewportView(null);
            if (this.getAvailableHeight() > 0) {
                if (this.requiresVerticalScrollbars()) {
                    ControlPanel.this.controlPane.setLocation(0, 0);
                    ControlPanel.this.verticalScrollPane.setViewportView(ControlPanel.this.controlPane);
                    ControlPanel.this.addToPanel(ControlPanel.this.verticalScrollPane);
                    ControlPanel.this.verticalScrollPane.setLocation(0, this.getControlTop());
                    ControlPanel.this.verticalScrollPane.setSize(new Dimension(((ControlPanel)ControlPanel.this).controlPane.getPreferredSize().width + this.getScrollBarWidth(), this.getAvailableHeight()));
                    ControlPanel.this.verticalScrollPane.revalidate();
                } else {
                    ControlPanel.this.addToPanel(ControlPanel.this.controlPane);
                    ControlPanel.this.controlPane.setBounds(0, this.getControlTop(), ((ControlPanel)ControlPanel.this).controlPane.getPreferredSize().width, ((ControlPanel)ControlPanel.this).controlPane.getPreferredSize().height);
                }
            }
            if (this.isMacOSX()) {
                this.fixAll(ControlPanel.this.controlPane);
            }
        }

        private boolean requiresVerticalScrollbars() {
            return ((ControlPanel)ControlPanel.this).controlPane.getPreferredSize().height > this.getAvailableHeight();
        }

        private int getAvailableHeight() {
            int n = this.getControlTop();
            int n2 = this.getControlBottom();
            int n3 = n2 - n;
            return n3;
        }

        private int getControlTop() {
            int n = this.getLogoBottom() + ControlPanel.this.paddingDY;
            return n;
        }

        private boolean isMacOSX() {
            String string = System.getProperty("os.name").toLowerCase();
            boolean bl = string.startsWith("mac os x");
            return bl;
        }

        public void fixAll(Component component) {
            Container container;
            Dimension dimension = component.getPreferredSize();
            component.setBounds(component.getX(), component.getY(), dimension.width, dimension.height);
            component.repaint();
            if (component instanceof Container) {
                container = (Container)component;
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    this.fixAll(container.getComponent(i));
                }
            }
            if (component instanceof JSlider) {
                container = (JSlider)component;
                Dimension dimension2 = container.getSize();
                ++dimension2.height;
                container.setSize(dimension2);
                container.repaint();
                --dimension2.height;
                container.setSize(dimension2);
                container.repaint();
            }
        }

        private int getPositionToCenter(Component component) {
            int n = ControlPanel.this.getWidth() - component.getWidth();
            if (n <= 0) {
                return 0;
            }
            return n / 2;
        }

        private int getHelpTop() {
            if (ControlPanel.this.helpPanel.isVisible() && this.containsComponent(ControlPanel.this.helpPanel)) {
                return ControlPanel.this.helpPanel.getY();
            }
            return ControlPanel.this.getHeight();
        }

        private int getLogoBottom() {
            if (ControlPanel.this.northPanel.isVisible() && this.containsComponent(ControlPanel.this.northPanel)) {
                return ControlPanel.this.northPanel.getY() + ControlPanel.this.northPanel.getHeight();
            }
            return 0;
        }

        private boolean containsComponent(Component component) {
            return Arrays.asList(ControlPanel.this.getComponents()).contains(component);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.getMinWidth();
            return new Dimension(n, container.getHeight());
        }

        private int getMinWidth() {
            int n = 0;
            if (ControlPanel.this.northPanel.isVisible()) {
                n = Math.max(n, ((ControlPanel)ControlPanel.this).northPanel.getPreferredSize().width);
            }
            if (ControlPanel.this.controlPane.isVisible()) {
                n = Math.max(n, ((ControlPanel)ControlPanel.this).controlPane.getPreferredSize().width);
            }
            if (ControlPanel.this.helpPanel.isVisible()) {
                n = Math.max(n, ((ControlPanel)ControlPanel.this).helpPanel.getPreferredSize().width);
            }
            if (this.getLayoutRequiresScrollPane()) {
                n += this.getScrollBarWidth();
            }
            return n;
        }

        private int getScrollBarWidth() {
            return ((ControlPanel)ControlPanel.this).verticalScrollPane.getVerticalScrollBar().getPreferredSize().width;
        }

        private boolean getLayoutRequiresScrollPane() {
            return this.getAvailableHeight() < ((ControlPanel)ControlPanel.this).controlPane.getPreferredSize().height;
        }

        private int getControlBottom() {
            int n = this.getHelpTop() - ControlPanel.this.paddingDY;
            return n;
        }
    }
}

