/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class PhetLookAndFeel {
    private static final String[] types = new String[]{"Button", "CheckBox", "CheckBoxMenuItem", "ComboBox", "Dialog", "Label", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "RadioButton", "RadioButtonMenuItem", "Slider", "Spinner", "TabbedPane", "TextArea", "TextField", "TextPane"};
    private int os = PhetLookAndFeel.getOperatingSystem();
    private Font font;
    private Font titledBorderFont;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color textFieldBackgroundColor;
    private Insets insets;

    public PhetLookAndFeel() {
        this.setDefaults();
    }

    private void setDefaults() {
        int n = PhetLookAndFeel.getFontSizeForScreen();
        this.font = new Font("Lucida Sans", 0, n);
        this.titledBorderFont = new Font("Lucida Sans", 0, n);
        this.foregroundColor = Color.BLACK;
        this.backgroundColor = new Color(200, 240, 200);
        this.textFieldBackgroundColor = Color.WHITE;
        this.insets = null;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void apply() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        this.putDefaults(uIDefaults);
    }

    public void putDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = this.constructDefaults();
        uIDefaults.putDefaults(objectArray);
    }

    private Object[] constructDefaults() {
        FontUIResource fontUIResource = null;
        FontUIResource fontUIResource2 = null;
        ColorUIResource colorUIResource = null;
        ColorUIResource colorUIResource2 = null;
        ColorUIResource colorUIResource3 = null;
        InsetsUIResource insetsUIResource = null;
        if (this.font != null) {
            fontUIResource = new FontUIResource(this.font);
        }
        if (this.titledBorderFont != null) {
            fontUIResource2 = new FontUIResource(this.titledBorderFont);
        }
        if (this.backgroundColor != null) {
            colorUIResource = new ColorUIResource(this.backgroundColor);
        }
        if (this.foregroundColor != null) {
            colorUIResource2 = new ColorUIResource(this.foregroundColor);
        }
        if (this.textFieldBackgroundColor != null) {
            colorUIResource3 = new ColorUIResource(this.textFieldBackgroundColor);
        }
        if (this.insets != null) {
            insetsUIResource = new InsetsUIResource(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < types.length; ++i) {
            String string = types[i];
            if (fontUIResource != null) {
                this.add(arrayList, string, "font", fontUIResource);
            }
            if (colorUIResource2 != null) {
                this.add(arrayList, string, "foreground", colorUIResource2);
            }
            if (colorUIResource != null) {
                this.add(arrayList, string, "background", colorUIResource);
            }
            if (insetsUIResource == null) continue;
            this.add(arrayList, string, "margin", insetsUIResource);
        }
        if (fontUIResource2 != null) {
            this.add(arrayList, "TitledBorder", "font", fontUIResource2);
        }
        if (colorUIResource3 != null) {
            this.add(arrayList, "TextField", "background", colorUIResource3);
        }
        return arrayList.toArray();
    }

    private void add(ArrayList arrayList, String string, String string2, Object object) {
        arrayList.add(string + "." + string2);
        arrayList.add(object);
    }

    public static int getOperatingSystem() {
        String string = "";
        try {
            string = System.getProperty("os.name").toLowerCase();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = 2;
        if (string.indexOf("windows") >= 0) {
            n = 0;
        } else if (string.indexOf("mac") >= 0) {
            n = 1;
        }
        return n;
    }

    public static void setLookAndFeel() {
        int n = PhetLookAndFeel.getOperatingSystem();
        if (n == 0) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                unsupportedLookAndFeelException.printStackTrace();
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                unsupportedLookAndFeelException.printStackTrace();
            }
        }
    }

    public static int getFontSizeForScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        JPanel jPanel = new JPanel();
        int n = jPanel.getFont().getSize();
        if (dimension.width <= 800) {
            n = (int)((double)n * 0.78125);
        }
        return n;
    }
}

