/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.components;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.math.ModelViewTransform1D;
import edu.colorado.phet.common_force1d.view.util.SwingUtils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModelSlider
extends JPanel {
    private JTextField textField;
    private JSlider slider;
    private ModelViewTransform1D modelViewTransform;
    private String units;
    private NumberFormat formatter;
    private double min;
    private double max;
    private double initialValue;
    private ArrayList listeners = new ArrayList();
    private double value = Double.NaN;
    private int numMajorTicks;
    private int numMinorTicks;
    private JLabel titleLabel;
    private JTextField unitsReadout;
    private String title;
    static /* synthetic */ Class class$edu$colorado$phet$common_force1d$view$components$ModelSlider$IllegalValueException;

    public ModelSlider(String string, String string2, double d, double d2, double d3) {
        this(string, string2, d, d2, d3, new DecimalFormat("0.0#"));
    }

    public ModelSlider(String string, String string2, double d, double d2, double d3, NumberFormat numberFormat) {
        this.init(d, d2, numberFormat, string2, d3, string);
    }

    private void init(double d, double d2, NumberFormat numberFormat, String string, double d3, String string2) {
        while (this.getComponentCount() > 0) {
            this.remove(this.getComponent(0));
        }
        this.title = string2;
        this.min = d;
        this.max = d2;
        this.formatter = numberFormat;
        this.units = string;
        this.modelViewTransform = new ModelViewTransform1D(d, d2, 0, 100000000);
        this.initialValue = d3;
        this.numMajorTicks = 10;
        int n = 4;
        this.numMinorTicks = (this.numMajorTicks - 1) * n + 1;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.textField = this.createTextField();
        this.textField.setHorizontalAlignment(4);
        this.createSlider();
        this.titleLabel = new JLabel(string2);
        Font font = new Font("Lucida Sans", 1, 14);
        this.titleLabel.setFont(font);
        this.unitsReadout = new JTextField(" " + this.units);
        this.unitsReadout.setFocusable(false);
        this.unitsReadout.setEditable(false);
        this.unitsReadout.setBorder(null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.textField, "West");
        jPanel.add((Component)this.unitsReadout, "East");
        try {
            SwingUtils.addGridBagComponent(this, this.titleLabel, 0, 0, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, this.slider, 0, 1, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, jPanel, 0, 2, 2, 1, 0, 10);
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        this.setValue(d3);
    }

    public void setTitleFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public JTextField getUnitsReadout() {
        return this.unitsReadout;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.unitsReadout.setEnabled(bl);
        this.titleLabel.setEnabled(bl);
    }

    public void setNumMajorTicks(int n) {
        this.numMajorTicks = n;
        this.relabelSlider();
    }

    public void setNumMinorTicks(int n) {
        this.numMinorTicks = n;
        this.relabelSlider();
    }

    private void relabelSlider() {
        int n = 100000000 / (this.numMajorTicks - 1);
        int n2 = 100000000 / (this.numMinorTicks - 1);
        Font font = new Font("Lucida Sans", 0, 10);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100000000; i += n) {
            double d = this.modelViewTransform.viewToModel(i);
            JLabel jLabel = new JLabel(this.formatter.format(d));
            jLabel.setFont(font);
            hashtable.put(new Integer(i), jLabel);
        }
        this.slider.setLabelTable(hashtable);
        this.slider.setMajorTickSpacing(n);
        this.slider.setMinorTickSpacing(n2);
    }

    public void setModelLabels(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Number number = (Number)k;
            double d = number.doubleValue();
            int n = this.modelViewTransform.modelToView(d);
            hashtable2.put(new Integer(n), hashtable.get(k));
        }
        this.slider.setLabelTable(hashtable2);
    }

    private void createSlider() {
        int n = this.modelViewTransform.modelToView(this.initialValue);
        if (n < 0 || n > 100000000) {
            throw new RuntimeException("Illegal slider value, min=0, max=100000000, value=" + n);
        }
        final JSlider jSlider = new JSlider(0, 0, 100000000, n);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getValue();
                double d = ModelSlider.this.modelViewTransform.viewToModel(n);
                ModelSlider.this.setValue(d);
            }
        });
        int n2 = 100000000 / (this.numMinorTicks - 1);
        double d = Math.abs(this.modelViewTransform.viewToModel(n2 / 4));
        SliderKeyHandler sliderKeyHandler = new SliderKeyHandler(d);
        jSlider.addKeyListener(sliderKeyHandler);
        this.slider = jSlider;
        this.relabelSlider();
    }

    public void setPaintTicks(boolean bl) {
        this.slider.setPaintTicks(bl);
    }

    private void fireStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.listeners.get(i);
            ChangeEvent changeEvent = new ChangeEvent(this);
            changeListener.stateChanged(changeEvent);
        }
    }

    private JTextField createTextField() {
        JTextField jTextField = new JTextField(8);
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                ModelSlider.this.setValue(ModelSlider.this.getValue());
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ModelSlider.this.testCommit();
                } else if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 27) {
                    ModelSlider.this.setValue(ModelSlider.this.initialValue);
                }
            }
        });
        return jTextField;
    }

    public boolean testCommit() {
        try {
            this.commitEdit();
            return true;
        }
        catch (IllegalValueException illegalValueException) {
            String string = SimStrings.get("Common.ModelSlider.OutOfRange");
            String string2 = SimStrings.get("Common.ModelSlider.Minimum");
            String string3 = SimStrings.get("Common.ModelSlider.Maximum");
            String string4 = SimStrings.get("Common.ModelSlider.YouEntered");
            String string5 = SimStrings.get("Common.ModelSlider.Description");
            JOptionPane.showMessageDialog(this, string + ".\n" + string2 + "= " + illegalValueException.getMin() + ", " + string3 + "=" + illegalValueException.getMax() + "\n" + string4 + ": " + illegalValueException.getValue(), string5, 0);
            double d = this.getValue();
            this.textField.setText(this.formatter.format(d));
            return false;
        }
    }

    public void commitEdit() throws IllegalValueException {
        String string = this.textField.getText();
        try {
            double d = Double.parseDouble(string);
            if (!(d >= this.min) || !(d <= this.max)) {
                throw new IllegalValueException(this.min, this.max, d);
            }
            this.setValue(d);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void setValue(double d) {
        if (d == this.value) {
            return;
        }
        if (d >= this.min && d <= this.max) {
            String string = this.formatter.format(d);
            double d2 = Double.parseDouble(string = string.replace(',', '.'));
            if (this.value == d2) {
                return;
            }
            this.value = d2;
            this.textField.setText(string);
            int n = this.modelViewTransform.modelToView(d);
            if (n != this.slider.getValue()) {
                this.slider.setValue(n);
            }
            this.fireStateChanged();
        }
    }

    public double getValue() {
        return this.value;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    private class SliderKeyHandler
    implements KeyListener {
        int keyCode = -1;
        private Timer timer;
        private double delta;

        public SliderKeyHandler(double d) {
            this.delta = d;
            this.timer = new Timer(30, new ActionListener(this){
                private final /* synthetic */ SliderKeyHandler this$1;
                {
                    this.this$1 = sliderKeyHandler;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SliderKeyHandler.access$200(this.this$1);
                }
            });
            this.timer.setInitialDelay(300);
        }

        private void fire() {
            if (this.keyCode == -1) {
                return;
            }
            if (this.keyCode == 37 || this.keyCode == 40) {
                double d = ModelSlider.this.getValue() - this.delta;
                if (d < ModelSlider.this.min) {
                    d = ModelSlider.this.min;
                }
                ModelSlider.this.setValue(d);
            } else if (this.keyCode == 39 || this.keyCode == 38) {
                double d = ModelSlider.this.getValue() + this.delta;
                if (d > ModelSlider.this.max) {
                    d = ModelSlider.this.max;
                }
                ModelSlider.this.setValue(d);
            } else if (this.keyCode == 27 || this.keyCode == 32) {
                ModelSlider.this.setValue(ModelSlider.this.initialValue);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.keyCode = keyEvent.getKeyCode();
            this.fire();
            this.timer.setInitialDelay(200);
            this.timer.start();
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyCode = -1;
            this.timer.stop();
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.keyCode = keyEvent.getKeyCode();
            this.fire();
        }

        static /* synthetic */ void access$200(SliderKeyHandler sliderKeyHandler) {
            sliderKeyHandler.fire();
        }
    }

    public static class IllegalValueException
    extends Exception {
        private double min;
        private double max;
        private double value;

        public IllegalValueException(double d, double d2, double d3) {
            super((class$edu$colorado$phet$common_force1d$view$components$ModelSlider$IllegalValueException == null ? (class$edu$colorado$phet$common_force1d$view$components$ModelSlider$IllegalValueException = ModelSlider.class$("edu.colorado.phet.common_force1d.view.components.ModelSlider$IllegalValueException")) : class$edu$colorado$phet$common_force1d$view$components$ModelSlider$IllegalValueException).getName() + " min=" + d + ", max=" + d2 + " value=" + d3);
            this.min = d;
            this.max = d2;
            this.value = d3;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getValue() {
            return this.value;
        }
    }
}

