/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.phetgraphics;

import edu.colorado.phet.common_force1d.view.BasicGraphicsSetup;
import edu.colorado.phet.common_force1d.view.GraphicsSetup;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class BufferedPhetGraphic
extends PhetGraphic {
    private GraphicLayerSet graphicLayerSet;
    private Paint background;
    private BufferedImage buffer;
    private int type;
    private GraphicsSetup graphicsSetup = new BasicGraphicsSetup();

    public BufferedPhetGraphic(Component component, int n, int n2, Paint paint) {
        this(component, n, n2, 1, paint);
    }

    public BufferedPhetGraphic(Component component, int n, int n2, int n3, Paint paint) {
        super(component);
        this.background = paint;
        this.type = n3;
        this.graphicLayerSet = new CompositePhetGraphic(component);
        if (n > 0 && n2 > 0) {
            this.buffer = new BufferedImage(n, n2, n3);
        }
        this.repaintBuffer();
    }

    public void repaintBuffer() {
        this.repaintBuffer(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
    }

    public void setSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.buffer = new BufferedImage(n, n2, this.type);
        }
        this.setBoundsDirty();
        this.autorepaint();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public void setBackground(Paint paint) {
        this.background = paint;
    }

    protected Rectangle determineBounds() {
        Rectangle rectangle = this.getNetTransform().createTransformedShape(new Rectangle(this.buffer.getWidth(), this.buffer.getHeight())).getBounds();
        return rectangle;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            graphics2D.drawRenderedImage(this.buffer, this.getNetTransform());
            super.restoreGraphicsState();
        }
    }

    public void addGraphic(PhetGraphic phetGraphic) {
        this.graphicLayerSet.addGraphic(phetGraphic);
    }

    public void setGraphicsSetup(GraphicsSetup graphicsSetup) {
        this.graphicsSetup = graphicsSetup;
    }

    public void repaintBuffer(int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = this.buffer.createGraphics();
        if (this.graphicsSetup != null) {
            this.graphicsSetup.setup(graphics2D);
        }
        graphics2D.setClip(n, n2, n3, n4);
        if (this.background != null) {
            graphics2D.setPaint(this.background);
            graphics2D.fillRect(n, n2, n3, n4);
        }
        if (this.buffer != null) {
            this.graphicLayerSet.paint(graphics2D);
        }
    }
}

