/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.phetgraphics;

import edu.colorado.phet.common_force1d.view.graphics.mousecontrols.CompositeMouseInputListener;
import edu.colorado.phet.common_force1d.view.graphics.mousecontrols.CursorControl;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositeKeyListener;
import edu.colorado.phet.common_force1d.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common_force1d.view.util.GraphicsState;
import edu.colorado.phet.common_force1d.view.util.RectangleUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.MouseInputListener;

public abstract class PhetGraphic {
    public static boolean SKIP_RECTANGLE_COMPUTATION = false;
    private Point location = new Point();
    private Point registrationPoint = new Point();
    private AffineTransform transform = new AffineTransform();
    private Rectangle lastBounds = new Rectangle();
    private Rectangle bounds = new Rectangle();
    private Component component;
    private boolean visible = true;
    private boolean boundsDirty = true;
    private RenderingHints renderingHints;
    private Stack graphicsStates = new Stack();
    private GraphicLayerSet parent;
    private Shape clip;
    protected CompositeMouseInputListener mouseInputListener = new CompositeMouseInputListener();
    protected CompositeKeyListener keyListener = new CompositeKeyListener();
    private CursorControl cursorControl;
    private ArrayList listeners = new ArrayList();
    private boolean ignoreMouse = false;
    private boolean autorepaint = true;
    AffineTransform netUtilTx = new AffineTransform();
    AffineTransform xlateUtilTx = new AffineTransform();
    private boolean clippingDisabled = false;

    protected PhetGraphic(Component component) {
        this.component = component;
    }

    protected PhetGraphic() {
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setParent(GraphicLayerSet graphicLayerSet) {
        this.parent = graphicLayerSet;
    }

    protected void saveGraphicsState(Graphics2D graphics2D) {
        this.graphicsStates.push(new GraphicsState(graphics2D));
    }

    protected void restoreGraphicsState() {
        if (!this.graphicsStates.empty()) {
            GraphicsState graphicsState = (GraphicsState)this.graphicsStates.pop();
            graphicsState.restoreGraphics();
        }
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    protected void updateGraphicsState(Graphics2D graphics2D) {
        RenderingHints renderingHints;
        if (this.clip != null) {
            graphics2D.setClip(this.clip);
        }
        if ((renderingHints = this.getRenderingHints()) != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.forceRepaint();
            this.fireVisibilityChanged();
            if (!bl && this.parent != null) {
                this.parent.childBecameInvisible(this);
            }
        }
    }

    protected void fireVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PhetGraphicListener phetGraphicListener = (PhetGraphicListener)this.listeners.get(i);
            phetGraphicListener.phetGraphicVisibilityChanged(this);
        }
    }

    public boolean isVisible() {
        if (this.parent != null) {
            return this.parent.isVisible() && this.visible;
        }
        return this.visible;
    }

    public void setRegistrationPoint(Point point) {
        this.setRegistrationPoint(point.x, point.y);
    }

    public void setRegistrationPoint(int n, int n2) {
        this.registrationPoint.setLocation(n, n2);
        this.setBoundsDirty();
        this.autorepaint();
    }

    public void setTransform(AffineTransform affineTransform) {
        if (!affineTransform.equals(this.transform)) {
            this.transform = new AffineTransform(affineTransform);
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    protected void preConcatenateTransform(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.transform.preConcatenate(affineTransform);
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    public AffineTransform getNetTransform() {
        this.netUtilTx.setToIdentity();
        this.xlateUtilTx.setToTranslation(-this.registrationPoint.x, -this.registrationPoint.y);
        this.netUtilTx.preConcatenate(this.xlateUtilTx);
        this.netUtilTx.preConcatenate(this.transform);
        this.xlateUtilTx.setToTranslation(this.location.x, this.location.y);
        this.netUtilTx.preConcatenate(this.xlateUtilTx);
        if (this.parent != null) {
            AffineTransform affineTransform = this.parent.getNetTransform();
            this.netUtilTx.preConcatenate(affineTransform);
        }
        return this.netUtilTx;
    }

    public void scale(double d, double d2) {
        this.preConcatenateTransform(AffineTransform.getScaleInstance(d, d2));
    }

    protected abstract Rectangle determineBounds();

    public Rectangle getBounds() {
        this.syncBounds();
        return this.bounds;
    }

    public void setBoundsDirty() {
        this.boundsDirty = true;
    }

    public boolean contains(int n, int n2) {
        if (this.isVisible()) {
            this.syncBounds();
            return this.bounds != null && this.bounds.contains(n, n2);
        }
        return false;
    }

    protected void syncBounds() {
        if (this.boundsDirty) {
            this.rebuildBounds();
            this.boundsDirty = false;
            if (!RectangleUtils.areEqual(this.lastBounds, this.bounds)) {
                this.notifyChanged();
            }
        }
    }

    private void rebuildBounds() {
        Rectangle rectangle = this.determineBounds();
        if (rectangle != null) {
            this.lastBounds.setBounds(this.bounds);
            this.bounds.setBounds(rectangle);
        }
    }

    public Rectangle getLocalBounds() {
        if (this.parent == null) {
            return this.getBounds();
        }
        Rectangle rectangle = this.getBounds();
        AffineTransform affineTransform = this.parent.getNetTransform();
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            Rectangle rectangle2 = affineTransform2.createTransformedShape(rectangle).getBounds();
            return rectangle2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        if (this.location.x != n || this.location.y != n2) {
            this.location.setLocation(n, n2);
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    public Point getLocation() {
        return new Point(this.location);
    }

    public int getX() {
        return this.location.x;
    }

    public int getY() {
        return this.location.y;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this.getBounds().width;
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    public void addPhetGraphicListener(PhetGraphicListener phetGraphicListener) {
        this.listeners.add(phetGraphicListener);
    }

    protected void notifyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PhetGraphicListener phetGraphicListener = (PhetGraphicListener)this.listeners.get(i);
            phetGraphicListener.phetGraphicChanged(this);
        }
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListener.addMouseInputListener(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListener.removeMouseInputListener(mouseInputListener);
    }

    public int numMouseInputListeners() {
        return this.mouseInputListener.numMouseInputListeners();
    }

    public void setIgnoreMouse(boolean bl) {
        this.ignoreMouse = bl;
    }

    public boolean getIgnoreMouse() {
        return this.ignoreMouse;
    }

    public void fireMouseClicked(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseClicked(mouseEvent);
        }
    }

    public void fireMousePressed(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mousePressed(mouseEvent);
        }
    }

    public void fireMouseReleased(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseReleased(mouseEvent);
        }
    }

    public void fireMouseEntered(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseEntered(mouseEvent);
        }
    }

    public void fireMouseExited(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseExited(mouseEvent);
        }
    }

    public void fireMouseExitedBecauseInvisible(MouseEvent mouseEvent) {
        this.mouseInputListener.mouseExited(mouseEvent);
    }

    public void fireMouseDragged(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseDragged(mouseEvent);
        }
    }

    public void fireMouseMoved(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseMoved(mouseEvent);
        }
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null && this.cursorControl != null) {
            this.removeCursor();
        }
        if (this.cursorControl == null) {
            this.cursorControl = new CursorControl(cursor);
            this.addMouseInputListener(this.cursorControl);
        }
    }

    public void setCursorHand() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void removeCursor() {
        this.removeMouseInputListener(this.cursorControl);
    }

    public abstract void paint(Graphics2D var1);

    public void setAutoRepaint(boolean bl) {
        this.autorepaint = bl;
    }

    public void autorepaint() {
        if (this.autorepaint) {
            this.repaint();
        }
    }

    public void repaint() {
        if (this.isVisible()) {
            this.forceRepaint();
        }
    }

    protected void forceRepaint() {
        this.syncBounds();
        if (SKIP_RECTANGLE_COMPUTATION) {
            return;
        }
        if (this.lastBounds != null) {
            this.component.repaint(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        }
        if (this.bounds != null) {
            this.component.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener.addKeyListener(keyListener);
    }

    public void fireKeyTyped(KeyEvent keyEvent) {
        if (this.isVisible()) {
            this.keyListener.keyTyped(keyEvent);
        }
    }

    public void fireKeyPressed(KeyEvent keyEvent) {
        if (this.isVisible()) {
            this.keyListener.keyPressed(keyEvent);
        }
    }

    public void fireKeyReleased(KeyEvent keyEvent) {
        if (this.isVisible()) {
            this.keyListener.keyReleased(keyEvent);
        }
    }

    public void gainedKeyFocus() {
    }

    public void lostKeyFocus() {
    }
}

