/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.phetgraphics;

import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.util.ImageLoader;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class PhetImageGraphic
extends PhetGraphic {
    private BufferedImage image;
    private boolean shapeDirty = true;
    private Shape shape;
    private String imageResourceName;

    public PhetImageGraphic(Component component, String string) {
        this(component, (BufferedImage)null);
        BufferedImage bufferedImage;
        this.imageResourceName = string;
        try {
            bufferedImage = ImageLoader.loadBufferedImage(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Image resource not found: " + string);
        }
        this.setImage(bufferedImage);
    }

    public PhetImageGraphic(Component component, BufferedImage bufferedImage) {
        this(component, bufferedImage, 0, 0);
    }

    public PhetImageGraphic(Component component, BufferedImage bufferedImage, int n, int n2) {
        super(component);
        this.image = bufferedImage;
        this.setLocation(n, n2);
    }

    public Shape getShape() {
        AffineTransform affineTransform = this.getNetTransform();
        if (this.shapeDirty) {
            if (this.image == null) {
                return null;
            }
            Rectangle rectangle = new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight());
            this.shape = affineTransform.createTransformedShape(rectangle);
            this.shapeDirty = false;
        }
        return this.shape;
    }

    public boolean contains(int n, int n2) {
        return this.isVisible() && this.getShape() != null && this.getShape().contains(n, n2);
    }

    protected Rectangle determineBounds() {
        return this.getShape() == null ? null : this.getShape().getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible() && this.image != null) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            try {
                graphics2D.drawRenderedImage(this.image, this.getNetTransform());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            super.restoreGraphicsState();
        }
    }

    public void setBoundsDirty() {
        super.setBoundsDirty();
        this.shapeDirty = true;
    }

    public void setImage(BufferedImage bufferedImage) {
        if (this.image != bufferedImage) {
            this.image = bufferedImage;
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public PhetImageGraphic() {
    }
}

