/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class BufferedImageUtils {
    public static BufferedImage rescaleYMaintainAspectRatio(Component component, BufferedImage bufferedImage, int n) {
        double d = bufferedImage.getHeight();
        double d2 = (double)n / d;
        return BufferedImageUtils.rescaleFractional(component, bufferedImage, d2, d2);
    }

    public static BufferedImage rescaleFractional(Component component, BufferedImage bufferedImage, double d, double d2) {
        return BufferedImageUtils.rescaleFractionalMacFriendly(component, bufferedImage, d, d2);
    }

    public static BufferedImage rescaleFractionalMacFriendly(Component component, BufferedImage bufferedImage, double d, double d2) {
        int n = (int)((double)bufferedImage.getWidth() * d);
        int n2 = (int)((double)bufferedImage.getHeight() * d2);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public static BufferedImage flipX(BufferedImage bufferedImage) {
        return BufferedImageUtils.flipXMacFriendly(bufferedImage);
    }

    public static BufferedImage flipXMacFriendly(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        if (bufferedImage.getType() == 0) {
            n = 2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = BufferedImageUtils.createTransformFlipX(bufferedImage);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    private static AffineTransform createTransformFlipX(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        return affineTransform;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static int getTransparency(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().getTransparency();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n = 1;
        if (colorModel != null) {
            n = colorModel.getTransparency();
        }
        return n;
    }

    public static BufferedImage toBufferedImage(Image image) {
        int n;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            n = BufferedImageUtils.getTransparency(image);
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            n = BufferedImageUtils.hasAlpha(image) ? 1 : 0;
            int n2 = 1;
            if (n != 0) {
                n2 = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

