/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;

public interface FrameSetup {
    public void initialize(JFrame var1);

    public static class MaxExtent
    implements FrameSetup {
        FrameSetup pre = null;

        public void initialize(JFrame jFrame) {
            if (this.pre != null) {
                this.pre.initialize(jFrame);
            }
            int n = jFrame.getExtendedState();
            jFrame.setExtendedState(n |= 6);
        }
    }

    public static class CenteredWithInsets
    implements FrameSetup {
        private int insetX;
        private int insetY;

        public CenteredWithInsets(int n, int n2) {
            this.insetX = n;
            this.insetY = n2;
        }

        public static void setup(Window window, int n, int n2) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n3 = dimension.width - n * 2;
            int n4 = dimension.height - n2 * 2;
            window.setSize(n3, n4);
            window.setLocation(n, n2);
        }

        public void initialize(JFrame jFrame) {
            CenteredWithInsets.setup(jFrame, this.insetX, this.insetY);
        }
    }
}

