/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.util;

import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphics2D;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class GraphicsState {
    private Graphics2D g2;
    private RenderingHints renderingHints;
    private Paint paint;
    private Color color;
    private Stroke stroke;
    private Composite composite;
    private AffineTransform transform;
    private Font font;
    private Shape clip;
    private Color background;

    public GraphicsState(Graphics2D graphics2D) {
        this.g2 = graphics2D;
        if (this.g2 instanceof PhetGraphics2D) {
            PhetGraphics2D phetGraphics2D = (PhetGraphics2D)this.g2;
            phetGraphics2D.pushState();
        } else {
            this.renderingHints = graphics2D.getRenderingHints();
            this.paint = graphics2D.getPaint();
            this.color = graphics2D.getColor();
            this.stroke = graphics2D.getStroke();
            this.composite = graphics2D.getComposite();
            this.transform = graphics2D.getTransform();
            this.font = graphics2D.getFont();
            this.clip = graphics2D.getClip();
            this.background = graphics2D.getBackground();
        }
    }

    public void restoreGraphics() {
        if (this.g2 instanceof PhetGraphics2D) {
            PhetGraphics2D phetGraphics2D = (PhetGraphics2D)this.g2;
            phetGraphics2D.popState();
        } else {
            if (this.g2.getRenderingHints() != this.renderingHints) {
                this.g2.setRenderingHints(this.renderingHints);
            }
            if (this.g2.getPaint() != this.paint) {
                this.g2.setPaint(this.paint);
            }
            if (this.g2.getColor() != this.color) {
                this.g2.setColor(this.color);
            }
            if (this.g2.getStroke() != this.stroke) {
                this.g2.setStroke(this.stroke);
            }
            if (this.g2.getComposite() != this.composite) {
                this.g2.setComposite(this.composite);
            }
            if (this.g2.getTransform() != this.transform) {
                this.g2.setTransform(this.transform);
            }
            if (this.g2.getFont() != this.font) {
                this.g2.setFont(this.font);
            }
            if (this.g2.getClip() != this.clip) {
                this.g2.setClip(this.clip);
            }
            if (this.g2.getBackground() != this.background) {
                this.g2.setBackground(this.background);
            }
        }
    }
}

