/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_force1d.view.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class RectangleUtils {
    public static Rectangle expand(Rectangle rectangle, int n, int n2) {
        return new Rectangle(rectangle.x - n, rectangle.y - n2, rectangle.width + n * 2, rectangle.height + n2 * 2);
    }

    public static Rectangle toRectangle(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        if (rectangle2D instanceof Rectangle) {
            return (Rectangle)rectangle2D;
        }
        return new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public static Point getLeftCenter(Rectangle rectangle) {
        Point point = rectangle.getLocation();
        point.translate(0, rectangle.height / 2);
        return point;
    }

    public static Point getTopCenter(Rectangle rectangle) {
        Point point = rectangle.getLocation();
        point.translate(rectangle.width / 2, 0);
        return point;
    }

    public static Point getBottomCenter(Rectangle rectangle) {
        Point point = rectangle.getLocation();
        point.translate(rectangle.width / 2, rectangle.height);
        return point;
    }

    public static Point getRightCenter(Rectangle rectangle) {
        Point point = rectangle.getLocation();
        point.translate(rectangle.width, rectangle.height / 2);
        return point;
    }

    public static Point getCenter(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static Rectangle union(Rectangle[] rectangleArray) {
        if (rectangleArray.length == 0) {
            return null;
        }
        Rectangle rectangle = null;
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle2 = rectangleArray[i];
            if (rectangle2 == null) continue;
            rectangle = rectangle == null ? new Rectangle(rectangle2) : rectangle.union(rectangle2);
        }
        return rectangle;
    }

    public static boolean areEqual(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null && rectangle2 == null) {
            return true;
        }
        if (rectangle != null && rectangle2 == null) {
            return false;
        }
        if (rectangle == null && rectangle2 != null) {
            return false;
        }
        return rectangle.equals(rectangle2);
    }

    public static Rectangle union(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            return null;
        }
        Rectangle rectangle = (Rectangle)arrayList.remove(0);
        while (arrayList.size() > 0) {
            rectangle = rectangle.union((Rectangle)arrayList.remove(0));
        }
        return rectangle;
    }
}

