/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.force1d_tag_chart;

import edu.colorado.phet.force1d_tag_chart.AbstractTicks;
import edu.colorado.phet.force1d_tag_chart.Chart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class Axis {
    private Chart chart;
    private AxisTicks minorTicks;
    private AxisTicks majorTicks;
    private Stroke stroke;
    private Color color;
    private int orientation;
    private double crossesOtherAxisAt = 0.0;
    private boolean visible = true;

    public Axis(Chart chart, int n) {
        this(chart, n, new BasicStroke(2.0f), Color.black, 2.0, 1.0);
    }

    public Axis(Chart chart, int n, Stroke stroke, Color color, double d, double d2) {
        this.minorTicks = new AxisTicks(chart, n, stroke, color, d);
        this.minorTicks.setShowLabels(false);
        this.majorTicks = new AxisTicks(chart, n, stroke, color, d2);
        this.majorTicks.setShowLabels(true);
        this.stroke = stroke;
        this.orientation = n;
        this.chart = chart;
        this.color = color;
        this.minorTicks.setVisible(false);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isInRange() && this.isVisible()) {
            Stroke stroke = graphics2D.getStroke();
            Color color = graphics2D.getColor();
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(this.color);
            if (this.orientation == 1) {
                Point2D.Double double_ = new Point2D.Double(this.chart.getRange().getMinX(), this.crossesOtherAxisAt);
                Point point = this.chart.transform(double_);
                Point2D.Double double_2 = new Point2D.Double(this.chart.getRange().getMaxX(), this.crossesOtherAxisAt);
                Point point2 = this.chart.transform(double_2);
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            } else if (this.orientation == 2) {
                Point2D.Double double_ = new Point2D.Double(this.crossesOtherAxisAt, this.chart.getRange().getMinY());
                Point point = this.chart.transform(double_);
                Point2D.Double double_3 = new Point2D.Double(this.crossesOtherAxisAt, this.chart.getRange().getMaxY());
                Point point3 = this.chart.transform(double_3);
                graphics2D.drawLine(point.x, point.y, point3.x, point3.y);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
            this.minorTicks.paint(graphics2D);
            this.majorTicks.paint(graphics2D);
        }
    }

    private boolean isInRange() {
        if (this.orientation == 1) {
            return this.chart.getRange().containsY(this.crossesOtherAxisAt);
        }
        if (this.orientation == 2) {
            return this.chart.getRange().containsX(this.crossesOtherAxisAt);
        }
        throw new RuntimeException("Illegal orientation");
    }

    private boolean isVisible() {
        return this.visible;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setMajorTickFont(Font font) {
        this.majorTicks.setFont(font);
    }

    public void setMajorTickSpacing(double d) {
        this.majorTicks.setSpacing(d);
    }

    public void setMajorTicksVisible(boolean bl) {
        this.majorTicks.setVisible(bl);
    }

    public void setMinorTicksVisible(boolean bl) {
        this.minorTicks.setVisible(bl);
    }

    public void setMajorGridlines(double[] dArray) {
        this.majorTicks.setGridlines(dArray);
    }

    public static class AxisTicks
    extends AbstractTicks {
        public AxisTicks(Chart chart, int n, Stroke stroke, Color color, double d) {
            super(chart, n, stroke, color, d, 0.0);
        }

        public int getVerticalTickX() {
            Point2D.Double double_ = new Point2D.Double(this.getCrossesOtherAxisAt(), this.getChart().getRange().getMinY());
            Point point = this.getChart().transform(double_);
            return point.x;
        }

        public int getHorizontalTickY() {
            Point2D.Double double_ = new Point2D.Double(this.getChart().getRange().getMinX(), this.getCrossesOtherAxisAt());
            Point point = this.getChart().transform(double_);
            return point.y;
        }
    }
}

