/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.force1d_tag_chart.controllers;

import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.force1d_tag_chart.Chart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputAdapter;

public class HorizontalCursor2
extends CompositePhetGraphic {
    private ArrayList listeners = new ArrayList();
    private double minX = Double.NEGATIVE_INFINITY;
    private double maxX = Double.POSITIVE_INFINITY;
    private Chart chart;
    private double modelX = 0.0;
    private int width;
    private Stroke stroke = new BasicStroke(1.0f, 2, 2, 2.0f, new float[]{6.0f, 4.0f}, 0.0f);
    private Rectangle shape = null;
    private PhetShapeGraphic shapeGraphic;

    public HorizontalCursor2(Component component, final Chart chart, Color color, Color color2, int n) {
        super(component);
        this.chart = chart;
        this.width = n;
        this.shape = new Rectangle();
        this.setCursorHand();
        this.addMouseInputListener(new MouseInputAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                double d = chart.getModelViewTransform().viewToModelX(mouseEvent.getX());
                d = Math.max(d, chart.getRange().getMinX());
                d = Math.min(d, chart.getRange().getMaxX());
                d = Math.max(d, HorizontalCursor2.this.minX);
                if ((d = Math.min(d, HorizontalCursor2.this.maxX)) != HorizontalCursor2.this.modelX) {
                    HorizontalCursor2.this.setModelX(d);
                    for (int i = 0; i < HorizontalCursor2.this.listeners.size(); ++i) {
                        Listener listener = (Listener)HorizontalCursor2.this.listeners.get(i);
                        listener.modelValueChanged(d);
                    }
                }
            }
        });
        chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                HorizontalCursor2.this.update();
            }
        });
        this.shapeGraphic = new PhetShapeGraphic(component, null, color, this.stroke, color2);
        this.addGraphic(this.shapeGraphic);
        this.update();
    }

    public void setX(double d) {
        this.setModelX(d);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setMaxX(double d) {
        this.maxX = d;
    }

    public void update() {
        int n = this.chart.getModelViewTransform().modelToViewX(this.modelX);
        int n2 = n - this.width / 2;
        int n3 = this.chart.getViewBounds().y;
        int n4 = this.chart.getViewBounds().height;
        this.shape.setBounds(n2, n3, this.width, n4);
        this.shapeGraphic.setShape(this.shape);
    }

    public void setModelX(double d) {
        this.modelX = d;
        this.update();
    }

    public static interface Listener {
        public void modelValueChanged(double var1);
    }
}

