/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.application.Module;
import edu.colorado.phet.common_force1d.application.PhetApplication;
import edu.colorado.phet.common_force1d.model.BaseModel;
import edu.colorado.phet.common_force1d.model.clock.AbstractClock;
import edu.colorado.phet.common_force1d.model.clock.ClockTickEvent;
import edu.colorado.phet.common_force1d.model.clock.SwingTimerClock;
import edu.colorado.phet.common_force1d.util.QuickTimer;
import edu.colorado.phet.common_force1d.view.PhetFrame;
import edu.colorado.phet.common_force1d.view.PhetLookAndFeel;
import edu.colorado.phet.common_force1d.view.util.FrameSetup;
import edu.colorado.phet.forces1d.CrashAudioPlayer;
import edu.colorado.phet.forces1d.Force1dControlPanel;
import edu.colorado.phet.forces1d.IForceControl;
import edu.colorado.phet.forces1d.SimpleControlPanel;
import edu.colorado.phet.forces1d.common.ColorDialog;
import edu.colorado.phet.forces1d.common.plotdevice.DefaultPlaybackPanel;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class Force1DApplication
extends Module {
    private PhetLookAndFeel phetLookAndFeel;
    private Force1DModel forceModel;
    protected Force1DPanel forcePanel;
    private Force1dControlPanel fullControlPanel;
    private SimpleControlPanel simpleControlPanel;
    private Force1dObject[] imageElements;
    private static boolean readyToRender = false;
    private DefaultPlaybackPanel playbackPanel;
    private PhetFrame phetFrame;
    private Force1DLookAndFeel force1DLookAndFeel = new Force1DLookAndFeel();
    private int objectIndex;
    private IForceControl currentControlPanel;
    private static final String VERSION = PhetApplicationConfig.getVersion("forces-1d").formatForTitleBar();

    public Force1DApplication(AbstractClock abstractClock, PhetLookAndFeel phetLookAndFeel) throws IOException {
        this(abstractClock, SimStrings.get("Force1DModule.moduleName"), phetLookAndFeel);
    }

    public Force1DApplication(AbstractClock abstractClock, String string, PhetLookAndFeel phetLookAndFeel) throws IOException {
        super(string, abstractClock);
        System.out.println("Force1DModule.Force1DModule-a");
        this.phetLookAndFeel = phetLookAndFeel;
        this.forceModel = new Force1DModel(this);
        this.setModel(new BaseModel());
        this.imageElements = new Force1dObject[]{new Force1dObject("forces-1d/images/cabinet.gif", SimStrings.get("Force1DModule.fileCabinet"), 0.8, 200.0, 0.3, 0.2), new Force1dObject("forces-1d/images/fridge.gif", SimStrings.get("Force1DModule.refrigerator"), 0.35, 400.0, 0.7, 0.5), new Force1dObject("forces-1d/images/phetbook.gif", SimStrings.get("Force1DModule.textbook"), 0.8, 10.0, 0.3, 0.25), new Force1dObject("forces-1d/images/crate.gif", SimStrings.get("Force1DModule.crate"), 0.8, 300.0, 0.2, 0.2), new Force1dObject("forces-1d/images/ollie.gif", SimStrings.get("Force1DModule.sleepyDog"), 0.5, 25.0, 0.1, 0.1)};
        System.out.println("Force1DModule.Force1DModule");
        this.forcePanel = new Force1DPanel(this);
        System.out.println("Force1DModule.Force1DModule2");
        this.forcePanel.addRepaintDebugGraphic(abstractClock);
        this.setApparatusPanel(this.forcePanel);
        this.fullControlPanel = new Force1dControlPanel(this);
        this.simpleControlPanel = new SimpleControlPanel(this);
        this.setControlPanel(this.simpleControlPanel);
        this.addModelElement(this.forceModel);
        this.playbackPanel = new DefaultPlaybackPanel(this.getForceModel().getPlotDeviceModel());
        this.getForceModel().setBoundsWalled();
        CrashAudioPlayer crashAudioPlayer = new CrashAudioPlayer();
        this.getForceModel().addCollisionListener(crashAudioPlayer);
    }

    public void updateGraphics(ClockTickEvent clockTickEvent) {
        super.updateGraphics(clockTickEvent);
        this.forcePanel.updateGraphics();
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this.forcePanel.setHelpEnabled(bl);
    }

    public Force1DModel getForceModel() {
        return this.forceModel;
    }

    public Force1DPanel getForcePanel() {
        return this.forcePanel;
    }

    public void reset() {
        this.forceModel.reset();
        this.forcePanel.reset();
        this.fullControlPanel.reset();
        this.simpleControlPanel.reset();
    }

    public void cursorMovedToTime(double d, int n) {
        this.forcePanel.cursorMovedToTime(d, n);
    }

    public void relayoutPlots() {
        if (this.forcePanel != null) {
            this.forcePanel.layoutPlots();
            this.forcePanel.invalidate();
            this.forcePanel.repaint();
        }
    }

    public PhetLookAndFeel getPhetLookAndFeel() {
        return this.phetLookAndFeel;
    }

    public static void main(final String[] stringArray) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Force1DApplication.runMain(stringArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    private static void runMain(String[] stringArray) throws IOException {
        SimStrings.getInstance().init(stringArray, "forces-1d/localization/forces-1d-strings");
        SimStrings.getInstance().addStrings("forces-1d/localization/phetcommon-strings");
        PhetLookAndFeel.setLookAndFeel();
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.apply();
        SwingTimerClock swingTimerClock = new SwingTimerClock(1.0, 30);
        FrameSetup.CenteredWithInsets centeredWithInsets = new FrameSetup.CenteredWithInsets(200, 200);
        String string = VERSION;
        PhetApplication phetApplication = new PhetApplication(stringArray, SimStrings.get("Force1DModule.title") + " (" + string + ")", SimStrings.get("Force1DModule.description"), string, swingTimerClock, false, centeredWithInsets);
        final Force1DApplication force1DApplication = new Force1DApplication(swingTimerClock, phetLookAndFeel);
        Module[] moduleArray = new Module[]{force1DApplication};
        phetApplication.setModules(moduleArray);
        JMenu jMenu = new JMenu(SimStrings.get("Force1DModule.options"));
        JMenuItem jMenuItem = new JMenuItem(SimStrings.get("Force1DModule.backgroundColor"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                force1DApplication.showColorDialog();
            }
        });
        jMenu.add(jMenuItem);
        phetApplication.getPhetFrame().addMenu(jMenu);
        phetApplication.startApplication();
        new FrameSetup.MaxExtent().initialize(phetApplication.getPhetFrame());
        if (PhetUtilities.isMacintosh()) {
            new FrameSetup.CenteredWithInsets(50, 50).initialize(phetApplication.getPhetFrame());
        }
        force1DApplication.setPhetFrame(phetApplication.getPhetFrame());
        Force1DApplication.setup(force1DApplication);
    }

    private void setPhetFrame(PhetFrame phetFrame) {
        this.phetFrame = phetFrame;
        this.getForcePanel().setPhetFrame(phetFrame);
    }

    private void showColorDialog() {
        String string = SimStrings.get("Force1DModule.chartcolor");
        ColorDialog.showDialog(string, this.getApparatusPanel(), Color.yellow, new ColorDialog.Listener(){

            public void colorChanged(Color color) {
                Force1DApplication.this.setChartBackground(color);
            }

            public void cancelled(Color color) {
                Force1DApplication.this.setChartBackground(color);
            }

            public void ok(Color color) {
                Force1DApplication.this.setChartBackground(color);
            }
        });
    }

    public void activate(PhetApplication phetApplication) {
        super.activate(phetApplication);
        phetApplication.getPhetFrame().getBasicPhetPanel().setAppControlPanel(this.playbackPanel);
    }

    private void setChartBackground(Color color) {
        this.forcePanel.setChartBackground(color);
    }

    private static void setup(Force1DApplication force1DApplication) {
        Force1DPanel force1DPanel = force1DApplication.getForcePanel();
        force1DPanel.setReferenceSize();
        force1DPanel.forceLayout(force1DPanel.getWidth(), force1DPanel.getHeight());
        force1DApplication.getApparatusPanel().getGraphic().setVisible(true);
        force1DPanel.paintImmediately(0, 0, force1DPanel.getWidth(), force1DPanel.getHeight());
    }

    public Force1dObject imageElementAt(int n) {
        return this.imageElements[n];
    }

    public Force1dObject[] getImageElements() {
        return this.imageElements;
    }

    public PhetFrame getPhetFrame() {
        return this.phetFrame;
    }

    public Force1DLookAndFeel getForce1DLookAndFeel() {
        return this.force1DLookAndFeel;
    }

    public void setObject(Force1dObject force1dObject) {
        this.objectIndex = Arrays.asList(this.imageElements).indexOf(force1dObject);
        try {
            this.getForcePanel().getBlockGraphic().setImage(force1dObject.getImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.forceModel.getBlock().setMass(force1dObject.getMass());
        this.forceModel.getBlock().setStaticFriction(force1dObject.getStaticFriction());
        this.forceModel.getBlock().setKineticFriction(force1dObject.getKineticFriction());
    }

    public void clearData() {
        this.getForcePanel().clearData();
    }

    public void setFrictionEnabled(boolean bl) {
        this.getForceModel().setFrictionEnabled(bl);
    }

    public void setImageIndex(int n) {
        try {
            this.getForcePanel().getBlockGraphic().setImage(this.imageElements[n].getImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getImageIndex() {
        return this.objectIndex;
    }

    public void restoreDefaults() {
        this.setObject(this.imageElements[this.objectIndex]);
        this.getForceModel().setGravity(9.8);
    }

    public void clockTicked(ClockTickEvent clockTickEvent) {
        QuickTimer quickTimer = new QuickTimer();
        QuickTimer quickTimer2 = new QuickTimer();
        this.handleControlUserInputs();
        this.getApparatusPanel().handleUserInput();
        Force1DApplication.debug("userInputTime = " + quickTimer2);
        QuickTimer quickTimer3 = new QuickTimer();
        this.getModel().clockTicked(clockTickEvent);
        Force1DApplication.debug("modelTime = " + quickTimer3);
        QuickTimer quickTimer4 = new QuickTimer();
        this.updateControlPanelGraphics();
        Force1DApplication.debug("updateControlPanelTime = " + quickTimer4);
        QuickTimer quickTimer5 = new QuickTimer();
        this.updateGraphics(clockTickEvent);
        Force1DApplication.debug("updateGraphicsTime = " + quickTimer5);
        QuickTimer quickTimer6 = new QuickTimer();
        this.getApparatusPanel().paint();
        Force1DApplication.debug("paintTime = " + quickTimer6);
        Force1DApplication.debug("totalTime = " + quickTimer);
    }

    private void handleControlUserInputs() {
        if (this.getActiveControlPanel() != null) {
            this.getActiveControlPanel().handleUserInput();
        }
    }

    private void updateControlPanelGraphics() {
        if (this.getActiveControlPanel() != null) {
            this.getActiveControlPanel().updateGraphics();
        }
    }

    public static void debug(String string) {
        boolean bl = false;
        if (bl) {
            System.out.println("str = " + string);
        }
    }

    public IForceControl getActiveControlPanel() {
        return this.currentControlPanel;
    }

    public void setSimpleControlPanel() {
        this.setControlPanel(this.simpleControlPanel);
    }

    public void setControlPanel(IForceControl iForceControl) {
        Window window;
        this.currentControlPanel = iForceControl;
        super.setControlPanel(iForceControl);
        if (this.phetFrame != null) {
            this.phetFrame.getBasicPhetPanel().setControlPanel(iForceControl);
            this.phetFrame.getBasicPhetPanel().invalidate();
            this.phetFrame.getBasicPhetPanel().validate();
            this.phetFrame.getBasicPhetPanel().doLayout();
        }
        if ((window = SwingUtilities.getWindowAncestor(iForceControl)) instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.invalidate();
            jFrame.doLayout();
        }
        this.fullControlPanel.getFreeBodyDiagramSuite().controlsChanged();
        this.simpleControlPanel.getFreeBodyDiagramSuite().controlsChanged();
    }

    public void setAdvancedControlPanel() {
        this.setControlPanel(this.fullControlPanel);
    }
}

