/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.view.components.ModelSlider;
import edu.colorado.phet.common_force1d.view.components.VerticalLayoutPanel;
import edu.colorado.phet.common_force1d.view.util.GraphicsState;
import edu.colorado.phet.forces1d.BarrierCheckBox;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.IForceControl;
import edu.colorado.phet.forces1d.ObjectComboBox;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.model.Block;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.FreeBodyDiagramSuite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Force1dControlPanel
extends IForceControl {
    private Force1DApplication module;
    private Force1DModel model;
    private FreeBodyDiagramSuite freeBodyDiagramSuite;
    private JComboBox comboBox;
    private ModelSlider mass;
    private ModelSlider gravity;
    private ModelSlider staticFriction;
    private ModelSlider kineticFriction;
    private BarrierCheckBox barriers;
    static final Stroke stroke = new BasicStroke(1.0f);

    public Force1dControlPanel(final Force1DApplication force1DApplication) {
        super(force1DApplication);
        this.module = force1DApplication;
        this.model = force1DApplication.getForceModel();
        this.freeBodyDiagramSuite = new FreeBodyDiagramSuite(force1DApplication);
        JButton jButton = new JButton(SimStrings.get("Force1dControlPanel.lessControls"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                force1DApplication.setSimpleControlPanel();
            }
        });
        this.addControl(jButton);
        this.freeBodyDiagramSuite.setControlPanel(this);
        this.addControl(this.freeBodyDiagramSuite.getCheckBox());
        this.addControl(this.freeBodyDiagramSuite.getFBDPanel());
        this.comboBox = new ObjectComboBox(force1DApplication, force1DApplication.getImageElements(), this);
        this.addControl(this.comboBox);
        this.mass = this.createControl(5.0, 0.1, 1000.0, SimStrings.get("Force1dControlPanel.mass"), SimStrings.get("Force1dControlPanel.kg"), new SpinnerHandler(){

            public void changed(double d) {
                Force1dControlPanel.this.model.getBlock().setMass(d);
            }
        });
        this.gravity = this.createControl(9.8, 0.0, 30.0, SimStrings.get("Force1dControlPanel.gravity"), SimStrings.get("Force1dControlPanel.gravityUnits"), new SpinnerHandler(){

            public void changed(double d) {
                Force1dControlPanel.this.model.setGravity(d);
            }
        });
        this.model.addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
            }

            public void gravityChanged() {
                Force1dControlPanel.this.gravity.setValue(Force1dControlPanel.this.model.getGravity());
            }
        });
        this.staticFriction = this.createControl(0.1, 0.0, 2.0, SimStrings.get("Force1dControlPanel.staticFriction"), "", new SpinnerHandler(){

            public void changed(double d) {
                Force1dControlPanel.this.model.getBlock().setStaticFriction(d);
            }
        });
        this.kineticFriction = this.createControl(0.05, 0.0, 2.0, SimStrings.get("Force1dControlPanel.kineticFriction"), "", new SpinnerHandler(){

            public void changed(double d) {
                Force1dControlPanel.this.model.getBlock().setKineticFriction(d);
            }
        });
        this.model.getBlock().addListener(new Block.Listener(){

            public void positionChanged() {
            }

            public void propertyChanged() {
                double d = Force1dControlPanel.this.model.getBlock().getStaticFriction();
                double d2 = Force1dControlPanel.this.model.getBlock().getKineticFriction();
                Force1dControlPanel.this.staticFriction.setValue(d);
                Force1dControlPanel.this.kineticFriction.setValue(d2);
            }
        });
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.add(this.gravity);
        verticalLayoutPanel.add(this.mass);
        verticalLayoutPanel.add(this.staticFriction);
        verticalLayoutPanel.add(this.kineticFriction);
        this.barriers = new BarrierCheckBox(force1DApplication);
        this.model.getBlock().addListener(new Block.Listener(){

            public void positionChanged() {
            }

            public void propertyChanged() {
                double d;
                double d2 = Force1dControlPanel.this.model.getBlock().getStaticFriction();
                if (d2 < (d = Force1dControlPanel.this.model.getBlock().getKineticFriction())) {
                    Force1dControlPanel.this.staticFriction.setValue(d);
                }
            }
        });
        this.model.getBlock().addListener(new Block.Listener(){

            public void positionChanged() {
            }

            public void propertyChanged() {
                double d = Force1dControlPanel.this.model.getBlock().getStaticFriction();
                double d2 = Force1dControlPanel.this.model.getBlock().getKineticFriction();
                Force1dControlPanel.this.staticFriction.setValue(d);
                Force1dControlPanel.this.kineticFriction.setValue(d2);
                Force1dControlPanel.this.mass.setValue(Force1dControlPanel.this.model.getBlock().getMass());
            }
        });
        force1DApplication.setObject(force1DApplication.imageElementAt(0));
        super.setHelpPanelEnabled(true);
        if (Toolkit.getDefaultToolkit().getScreenSize().width < 1280) {
            super.removeTitle();
        }
        force1DApplication.getForceModel().getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                Force1dControlPanel.this.enableChanges();
            }

            public void playbackStarted() {
                Force1dControlPanel.this.disableChanges();
            }

            public void playbackPaused() {
                Force1dControlPanel.this.enableChanges();
            }
        });
        JButton jButton2 = new JButton(SimStrings.get("Force1dControlPanel.restoreDefaults"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                force1DApplication.restoreDefaults();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.barriers);
        jPanel.add(jButton2);
        this.addControlFullWidth(jPanel);
        this.addControlFullWidth(verticalLayoutPanel);
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(1.67), Force1dControlPanel.toJLabel(SimStrings.get("Force1dControlPanel.moon")));
        hashtable.put(new Double(9.8), Force1dControlPanel.toJLabel(SimStrings.get("Force1dControlPanel.earth")));
        hashtable.put(new Double(22.9), Force1dControlPanel.toJLabel(SimStrings.get("Force1dControlPanel.jupiter")));
        this.gravity.setModelLabels(hashtable);
        this.gravity.setPaintTicks(false);
    }

    public static JLabel toJLabel(String string) {
        JLabel jLabel = new JLabel(string){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                GraphicsState graphicsState = new GraphicsState(graphics2D);
                graphics.setColor(Color.blue);
                int n = this.getWidth() / 2;
                graphics2D.setStroke(stroke);
                graphics.drawLine(n, 0, n, 2);
                graphicsState.restoreGraphics();
                super.paintComponent(graphics);
            }
        };
        jLabel.setFont(new Font("Lucida Sans", 0, 10));
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setPreferredSize(new Dimension(dimension.width, dimension.height + 5));
        return jLabel;
    }

    private void disableChanges() {
        this.setChangesEnabled(false);
    }

    private void enableChanges() {
        this.setChangesEnabled(true);
    }

    private void setChangesEnabled(boolean bl) {
        this.barriers.setEnabled(bl);
        this.comboBox.setEnabled(bl);
        this.mass.setEnabled(bl);
        this.gravity.setEnabled(bl);
        this.staticFriction.setEnabled(bl);
        this.kineticFriction.setEnabled(bl);
        this.barriers.setEnabled(bl);
    }

    private ModelSlider createControl(double d, double d2, double d3, String string, String string2, final SpinnerHandler spinnerHandler) {
        final ModelSlider modelSlider = new ModelSlider(string, string2, d2, d3, d);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = modelSlider.getValue();
                spinnerHandler.changed(d);
            }
        });
        spinnerHandler.changed(d);
        modelSlider.setNumMajorTicks(5);
        modelSlider.setNumMinorTicks(0);
        if (modelSlider.getUnitsReadout() != null) {
            modelSlider.getUnitsReadout().setBackground(this.module.getPhetLookAndFeel().getBackgroundColor());
        }
        modelSlider.setTitleFont(this.module.getPhetLookAndFeel().getFont());
        return modelSlider;
    }

    public void reset() {
        this.freeBodyDiagramSuite.reset();
    }

    public void handleUserInput() {
        this.freeBodyDiagramSuite.handleUserInput();
    }

    public void updateGraphics() {
        this.freeBodyDiagramSuite.updateGraphics();
    }

    public FreeBodyDiagramSuite getFreeBodyDiagramSuite() {
        return this.freeBodyDiagramSuite;
    }

    static interface SpinnerHandler {
        public void changed(double var1);
    }
}

