/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.view.util.BufferedImageUtils;
import edu.colorado.phet.common_force1d.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.Force1dControlPanel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ObjectComboBox
extends JComboBox {
    private Force1dControlPanel controlPanel;
    private static Font font = new Font("Lucida Sans", 1, 10);

    public ObjectComboBox(final Force1DApplication force1DApplication, final Force1dObject[] force1dObjectArray, Force1dControlPanel force1dControlPanel) {
        super(ObjectComboBox.toLabelArray(force1dObjectArray, force1dControlPanel));
        this.setRenderer(new ComboBoxRenderer());
        this.controlPanel = force1dControlPanel;
        if (Toolkit.getDefaultToolkit().getScreenSize().width >= 1280) {
            this.setBorder(Force1DUtil.createSmoothBorder(SimStrings.get("ObjectComboBox.chooseObject")));
        }
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = ObjectComboBox.this.getSelectedIndex();
                force1DApplication.setObject(force1dObjectArray[n]);
            }
        });
        this.setFont(font);
    }

    private static ImageIcon[] toLabelArray(Force1dObject[] force1dObjectArray, Component component) {
        ImageIcon[] imageIconArray = new ImageIcon[force1dObjectArray.length];
        for (int i = 0; i < imageIconArray.length; ++i) {
            try {
                BufferedImage bufferedImage = ImageLoader.loadBufferedImage(force1dObjectArray[i].getLocation());
                bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(component, bufferedImage, 35);
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                imageIcon.setDescription(force1dObjectArray[i].getName() + " (" + force1dObjectArray[i].getMass() + " " + SimStrings.get("ObjectComboBox.kg") + ")");
                imageIconArray[i] = imageIcon;
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return imageIconArray;
    }

    public static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            ImageIcon imageIcon = (ImageIcon)object;
            this.setText(imageIcon.getDescription());
            this.setIcon(imageIcon);
            this.setFont(font);
            return this;
        }
    }
}

