/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.view.util.BufferedImageUtils;
import edu.colorado.phet.common_force1d.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.SimpleControlPanel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ObjectSelectionPanel
extends JPanel {
    private Font selectedFont = new Font("Lucida Sans", 1, 13);
    private Font normalFont = new Font("Lucida Sans", 0, 13);

    public ObjectSelectionPanel(Force1dObject[] force1dObjectArray, final SimpleControlPanel simpleControlPanel) {
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton[] jRadioButtonArray = new JRadioButton[force1dObjectArray.length];
        int n = 0;
        while (n < force1dObjectArray.length) {
            JRadioButton jRadioButton;
            final Force1dObject force1dObject = force1dObjectArray[n];
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage(force1dObjectArray[n].getLocation());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(simpleControlPanel, bufferedImage, 35);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            jRadioButtonArray[n] = jRadioButton = new JRadioButton(force1dObject.getName() + " (" + force1dObject.getMass() + " kg)", imageIcon);
            if (n == 0) {
                jRadioButton.setSelected(true);
                jRadioButton.setFont(this.selectedFont);
            } else {
                jRadioButton.setFont(this.normalFont);
            }
            buttonGroup.add(jRadioButton);
            final int n2 = n++;
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    simpleControlPanel.setup(force1dObject);
                    for (int i = 0; i < jRadioButtonArray.length; ++i) {
                        JRadioButton jRadioButton = jRadioButtonArray[i];
                        if (i == n2) {
                            jRadioButton.setFont(ObjectSelectionPanel.this.selectedFont);
                            continue;
                        }
                        jRadioButton.setFont(ObjectSelectionPanel.this.normalFont);
                    }
                }
            });
            this.add(jRadioButton);
        }
        this.setBorder(Force1DUtil.createSmoothBorder(SimStrings.get("ObjectSelectionPanel.chooseObject")));
    }
}

