/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.forces1d.BarrierCheckBox;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.IForceControl;
import edu.colorado.phet.forces1d.ObjectSelectionPanel;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import edu.colorado.phet.forces1d.view.FreeBodyDiagramSuite;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleControlPanel
extends IForceControl {
    private FreeBodyDiagramSuite fbdSuite;
    private JCheckBox frictionCheckBox;
    private BarrierCheckBox barriers;
    private Force1DApplication simpleForceModule;

    public SimpleControlPanel(final Force1DApplication force1DApplication) {
        super(force1DApplication);
        this.simpleForceModule = force1DApplication;
        JButton jButton = new JButton(SimStrings.get("SimpleControlPanel.moreControls"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                force1DApplication.setAdvancedControlPanel();
            }
        });
        this.add(jButton);
        this.frictionCheckBox = new JCheckBox(SimStrings.get("SimpleControlPanel.friction"), true);
        this.frictionCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                force1DApplication.setFrictionEnabled(SimpleControlPanel.this.frictionCheckBox.isSelected());
            }
        });
        this.fbdSuite = new FreeBodyDiagramSuite(force1DApplication);
        this.fbdSuite.setControlPanel(this);
        this.addControl(this.fbdSuite.getCheckBox());
        this.addControl(this.fbdSuite.getFBDPanel());
        if (Toolkit.getDefaultToolkit().getScreenSize().width < 1200) {
            super.removeTitle();
        }
        this.addControl(this.frictionCheckBox);
        this.barriers = new BarrierCheckBox(force1DApplication);
        this.addControl(this.barriers);
        super.setHelpPanelEnabled(true);
        force1DApplication.getForceModel().getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                SimpleControlPanel.this.setChangesEnabled(true);
            }

            public void playbackStarted() {
                SimpleControlPanel.this.setChangesEnabled(false);
            }

            public void playbackPaused() {
                SimpleControlPanel.this.setChangesEnabled(true);
            }
        });
        ObjectSelectionPanel objectSelectionPanel = new ObjectSelectionPanel(force1DApplication.getImageElements(), this);
        this.addControl(objectSelectionPanel);
    }

    private void setChangesEnabled(boolean bl) {
        this.barriers.setEnabled(bl);
        this.frictionCheckBox.setEnabled(bl);
    }

    public void updateGraphics() {
        this.fbdSuite.updateGraphics();
    }

    public void reset() {
        this.fbdSuite.reset();
    }

    public void setup(Force1dObject force1dObject) {
        this.simpleForceModule.setObject(force1dObject);
    }

    public void handleUserInput() {
        this.fbdSuite.handleUserInput();
    }

    public FreeBodyDiagramSuite getFreeBodyDiagramSuite() {
        return this.fbdSuite;
    }
}

