/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common;

public class LayoutUtil {
    double min;
    double max;
    double separatorWidth;

    public LayoutUtil(double d, double d2, double d3) {
        this.min = d;
        this.max = d2;
        this.separatorWidth = d3;
    }

    public void layout(LayoutElement[] layoutElementArray) {
        double d = this.max - this.min;
        int n = layoutElementArray.length;
        int n2 = n - 1;
        double d2 = (double)n2 * this.separatorWidth;
        int n3 = 0;
        double d3 = 0.0;
        for (int i = 0; i < layoutElementArray.length; ++i) {
            LayoutElement layoutElement = layoutElementArray[i];
            if (layoutElement instanceof Fixed) {
                LayoutElement layoutElement2 = layoutElement;
                d3 += layoutElement2.getSize();
                continue;
            }
            ++n3;
        }
        double d4 = d - d2 - d3;
        double d5 = d4 / (double)n3;
        double d6 = this.min;
        for (int i = 0; i < layoutElementArray.length; ++i) {
            LayoutElement layoutElement;
            LayoutElement layoutElement3 = layoutElementArray[i];
            if (layoutElement3 instanceof Dynamic) {
                layoutElement = (Dynamic)layoutElement3;
                ((Dynamic)layoutElement).set(d6, d5);
                d6 += d5 + this.separatorWidth;
                continue;
            }
            layoutElement = (Fixed)layoutElement3;
            ((Fixed)layoutElement).min = d6;
            d6 += ((Fixed)layoutElement).size + this.separatorWidth;
        }
    }

    public static class Dynamic
    extends LayoutElement {
        public void set(double d, double d2) {
            this.min = d;
            this.size = d2;
        }
    }

    public static class Fixed
    extends LayoutElement {
        public Fixed(double d) {
            this.size = d;
        }
    }

    public static abstract class LayoutElement {
        protected double size;
        protected double min;

        public double getMin() {
            return this.min;
        }

        public double getSize() {
            return this.size;
        }

        public String toString() {
            return "min=" + this.min + ", size=" + this.size;
        }
    }
}

