/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common;

import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common_force1d.view.util.RectangleUtils;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class RelativeLocationSetter {
    public abstract void layout(Target var1, Movable var2);

    public void layout(PhetGraphic phetGraphic, PhetGraphic phetGraphic2) {
        this.layout(new PhetGraphicTarget(phetGraphic), new MovablePhetGraphic(phetGraphic2));
    }

    public static void follow(final Target target, final Movable movable, final RelativeLocationSetter relativeLocationSetter) {
        target.addBoundsObserver(new BoundsObserver(){

            public void boundsChanged() {
                relativeLocationSetter.layout(target, movable);
            }
        });
        target.addVisibilityObserver(new VisibilityObserver(){

            public void visibilityChanged() {
                movable.setVisible(target.isVisible());
            }
        });
        relativeLocationSetter.layout(target, movable);
    }

    public static void follow(PhetGraphic phetGraphic, PhetGraphic phetGraphic2, RelativeLocationSetter relativeLocationSetter) {
        RelativeLocationSetter.follow(new PhetGraphicTarget(phetGraphic), new MovablePhetGraphic(phetGraphic2), relativeLocationSetter);
    }

    public static class Left
    extends RelativeLocationSetter {
        int separation;

        public Left() {
            this(0);
        }

        public Left(int n) {
            this.separation = n;
        }

        public void layout(Target target, Movable movable) {
            Rectangle rectangle = target.getBounds();
            Point point = RectangleUtils.getLeftCenter(rectangle);
            Rectangle rectangle2 = movable.getBounds();
            int n = point.x - rectangle2.width - this.separation;
            int n2 = point.y - rectangle2.height / 2;
            movable.setLocation(n, n2);
        }
    }

    public static class Bottom
    extends RelativeLocationSetter {
        int separation;

        public Bottom() {
            this(0);
        }

        public Bottom(int n) {
            this.separation = n;
        }

        public void layout(Target target, Movable movable) {
            Rectangle rectangle = target.getBounds();
            Point point = RectangleUtils.getBottomCenter(rectangle);
            Rectangle rectangle2 = movable.getBounds();
            int n = point.x - rectangle2.width / 2;
            int n2 = point.y + this.separation;
            movable.setLocation(n, n2);
        }
    }

    public static class Right
    extends RelativeLocationSetter {
        int separation;

        public Right() {
            this(0);
        }

        public Right(int n) {
            this.separation = n;
        }

        public void layout(Target target, Movable movable) {
            Rectangle rectangle = target.getBounds();
            Point point = RectangleUtils.getRightCenter(rectangle);
            Rectangle rectangle2 = movable.getBounds();
            int n = point.x + this.separation;
            int n2 = point.y - rectangle2.height / 2;
            movable.setLocation(n, n2);
        }
    }

    public static class Top
    extends RelativeLocationSetter {
        int separation;

        public Top() {
            this(0);
        }

        public Top(int n) {
            this.separation = n;
        }

        public void layout(Target target, Movable movable) {
            Rectangle rectangle = target.getBounds();
            Point point = RectangleUtils.getTopCenter(rectangle);
            Rectangle rectangle2 = movable.getBounds();
            int n = point.x - rectangle2.width / 2;
            int n2 = point.y - rectangle2.height - this.separation;
            movable.setLocation(n, n2);
        }
    }

    public static class MovablePhetGraphic
    extends PhetGraphicTarget
    implements Movable {
        public MovablePhetGraphic(PhetGraphic phetGraphic) {
            super(phetGraphic);
        }

        public void setLocation(int n, int n2) {
            int n3 = this.getBounds().x;
            int n4 = this.getBounds().y;
            int n5 = n - n3;
            int n6 = n2 - n4;
            Point point = this.phetGraphic.getLocation();
            this.phetGraphic.setLocation(point.x + n5, point.y + n6);
        }

        public void setVisible(boolean bl) {
            this.phetGraphic.setVisible(bl);
        }
    }

    public static class PhetGraphicTarget
    implements Target {
        PhetGraphic phetGraphic;

        public PhetGraphicTarget(PhetGraphic phetGraphic) {
            this.phetGraphic = phetGraphic;
        }

        public Rectangle getBounds() {
            return this.phetGraphic.getBounds();
        }

        public void addBoundsObserver(BoundsObserver boundsObserver) {
            this.phetGraphic.addPhetGraphicListener(new PhetGraphicListener(this, boundsObserver){
                private final /* synthetic */ BoundsObserver val$boundsObserver;
                private final /* synthetic */ PhetGraphicTarget this$0;
                {
                    this.this$0 = phetGraphicTarget;
                    this.val$boundsObserver = boundsObserver;
                }

                public void phetGraphicChanged(PhetGraphic phetGraphic) {
                    this.val$boundsObserver.boundsChanged();
                }

                public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                }
            });
        }

        public void addVisibilityObserver(VisibilityObserver visibilityObserver) {
            this.phetGraphic.addPhetGraphicListener(new PhetGraphicListener(this, visibilityObserver){
                private final /* synthetic */ VisibilityObserver val$visibilityObserver;
                private final /* synthetic */ PhetGraphicTarget this$0;
                {
                    this.this$0 = phetGraphicTarget;
                    this.val$visibilityObserver = visibilityObserver;
                }

                public void phetGraphicChanged(PhetGraphic phetGraphic) {
                }

                public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                    this.val$visibilityObserver.visibilityChanged();
                }
            });
        }

        public boolean isVisible() {
            return this.phetGraphic.isVisible();
        }
    }

    public static interface Movable
    extends Target {
        public void setLocation(int var1, int var2);

        public void setVisible(boolean var1);
    }

    public static interface BoundsObserver {
        public void boundsChanged();
    }

    public static interface VisibilityObserver {
        public void visibilityChanged();
    }

    public static interface Target {
        public Rectangle getBounds();

        public void addBoundsObserver(BoundsObserver var1);

        public void addVisibilityObserver(VisibilityObserver var1);

        public boolean isVisible();
    }
}

