/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common;

import edu.colorado.phet.common_force1d.math.AbstractVector2D;
import edu.colorado.phet.common_force1d.math.Vector2D;
import edu.colorado.phet.common_force1d.model.clock.AbstractClock;
import edu.colorado.phet.common_force1d.model.clock.ClockTickEvent;
import edu.colorado.phet.common_force1d.model.clock.ClockTickListener;
import edu.colorado.phet.common_force1d.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.forces1d.common.ShadowHTMLGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;

public class WiggleMe
extends CompositePhetGraphic {
    private long t0 = System.currentTimeMillis();
    private double frequency = 2.5;
    private double amplitude = 30.0;
    private Vector2D.Double oscillationAxis;
    private Target target;
    private PhetShapeGraphic phetShapeGraphic;
    private ShadowHTMLGraphic textGraphic;
    private ClockTickListener tickListener;
    private AbstractClock clock;

    public WiggleMe(Component component, AbstractClock abstractClock, String string, PhetGraphic phetGraphic) {
        this(component, abstractClock, string, new PhetGraphicTarget(phetGraphic));
    }

    public WiggleMe(Component component, AbstractClock abstractClock, String string, Target target) {
        this(component, abstractClock, string, target, new Font("Lucida Sans", 1, 20), 1, 1);
    }

    public WiggleMe(Component component, AbstractClock abstractClock, String string, Target target, Font font, int n, int n2) {
        super(component);
        this.target = target;
        this.clock = abstractClock;
        this.oscillationAxis = new Vector2D.Double(0.0, 1.0);
        Color color = new Color(39, 27, 184);
        Color color2 = new Color(6, 0, 44);
        this.textGraphic = new ShadowHTMLGraphic(component, string, font, color, n, n2, color2);
        this.addGraphic(this.textGraphic);
        this.textGraphic.setLocation(0, 0);
        this.tickListener = new ClockTickListener(){

            public void clockTicked(ClockTickEvent clockTickEvent) {
                WiggleMe.this.tick();
            }
        };
        this.setVisible(true);
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(50.0, 0.0), 20.0, 20.0, 10.0);
        this.phetShapeGraphic = new PhetShapeGraphic(component, arrow.getShape(), Color.blue, new BasicStroke(2.0f), Color.black);
        this.addGraphic(this.phetShapeGraphic);
        this.setRegistrationPoint(this.getBounds().x, this.getBounds().y);
        this.tick();
        this.setIgnoreMouse(true);
        this.phetShapeGraphic.setLocation(this.textGraphic.getWidth() - this.phetShapeGraphic.getWidth() - 5, this.textGraphic.getHeight() + 5);
    }

    public void setOscillationAxis(Vector2D.Double double_) {
        this.oscillationAxis = double_;
    }

    public void setFrequency(double d) {
        this.frequency = d;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!this.clock.containsClockTickListener(this.tickListener)) {
                this.clock.addClockTickListener(this.tickListener);
            }
        } else {
            while (this.clock.containsClockTickListener(this.tickListener)) {
                this.clock.removeClockTickListener(this.tickListener);
            }
        }
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void setFont(Font font) {
        this.textGraphic.setFont(font);
    }

    public void setArrow(double d, double d2) {
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(d, d2), 20.0, 20.0, 10.0);
        this.phetShapeGraphic.setShape(arrow.getShape());
    }

    private void tick() {
        if (this.isVisible() && this.getComponent().isShowing()) {
            double d = (double)(System.currentTimeMillis() - this.t0) / 1000.0;
            Point point = this.target.getLocation();
            Point point2 = new Point(point.x - this.getWidth() - 5, point.y);
            double d2 = Math.sin(this.frequency * d) * this.amplitude;
            AbstractVector2D abstractVector2D = this.oscillationAxis.getInstanceOfMagnitude(d2);
            Point2D point2D = abstractVector2D.getDestination(point2);
            this.setLocation((int)point2D.getX(), (int)point2D.getY());
        }
    }

    public void setArrowColor(Color color) {
        this.phetShapeGraphic.setColor(color);
    }

    public static class PhetGraphicTarget
    implements Target {
        private PhetGraphic target;

        public PhetGraphicTarget(PhetGraphic phetGraphic) {
            this.target = phetGraphic;
        }

        public Point getLocation() {
            Point point = this.target.getLocation();
            return point;
        }
    }

    public static interface Target {
        public Point getLocation();
    }
}

