/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import java.util.ArrayList;

public class DataSeries {
    private ArrayList pts = new ArrayList();
    private ArrayList listeners = new ArrayList();

    public void addPoint(double d) {
        this.pts.add(new Double(d));
        this.updateObservers();
    }

    public double getLastPoint() {
        return this.lastPointAt(0);
    }

    public int size() {
        return this.pts.size();
    }

    public void reset() {
        this.pts = new ArrayList();
        this.updateObservers();
    }

    private void updateObservers() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.changed();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double lastPointAt(int n) {
        return this.pointAt(this.pts.size() - 1 - n);
    }

    public double pointAt(int n) {
        return (Double)this.pts.get(n);
    }

    public boolean indexInBounds(int n) {
        return n >= 0 && n < this.pts.size();
    }

    public static interface Listener {
        public void changed();
    }
}

