/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import edu.colorado.phet.common_force1d.math.MathUtil$Average;
import edu.colorado.phet.forces1d.model.DataSeries;

public class SmoothDataSeries {
    private DataSeries data = new DataSeries();
    private DataSeries smoothed = new DataSeries();
    private int windowSize;

    public SmoothDataSeries(int n) {
        this.windowSize = n;
    }

    private void updateSmoothedSeries() {
        MathUtil$Average mathUtil$Average = new MathUtil$Average();
        int n = this.windowSize;
        n = Math.min(n, this.data.size());
        for (int i = 0; i < n; ++i) {
            mathUtil$Average.update(this.data.lastPointAt(i));
        }
        double d = mathUtil$Average.value();
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.smoothed.addPoint(d);
    }

    public DataSeries getSmoothedDataSeries() {
        return this.smoothed;
    }

    public void addPoint(double d) {
        this.data.addPoint(d);
        this.updateSmoothedSeries();
    }

    public int numSmoothedPoints() {
        return this.smoothed.size();
    }

    public void reset() {
        this.data.reset();
        this.smoothed.reset();
    }

    public double smoothedPointAt(int n) {
        return this.smoothed.pointAt(n);
    }
}

