/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.math.Vector2D;
import edu.colorado.phet.common_force1d.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_force1d.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetShadowTextGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.BlockGraphic;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ArrowSetGraphic
extends CompositePhetGraphic {
    private Force1DPanel force1DPanel;
    private BlockGraphic blockGraphic;
    private Force1DModel model;
    private ModelViewTransform2D transform2D;
    private ForceArrowGraphic applied;
    private ForceArrowGraphic friction;
    private ForceArrowGraphic total;
    private ForceArrowGraphic wall;
    private double arrowTailWidth = 30.0;
    private double arrowHeadHeight = 55.0;
    private Force1DLookAndFeel laf;

    public ArrowSetGraphic(Force1DPanel force1DPanel, BlockGraphic blockGraphic, final Force1DModel force1DModel, ModelViewTransform2D modelViewTransform2D) {
        super(force1DPanel);
        this.force1DPanel = force1DPanel;
        this.blockGraphic = blockGraphic;
        this.model = force1DModel;
        this.transform2D = modelViewTransform2D;
        this.laf = force1DPanel.getLookAndFeel();
        this.applied = new ForceArrowGraphic(force1DPanel, SimStrings.get("ArrowSetGraphic.appliedForce"), this.laf.getAppliedForceColor(), 0, new ForceComponent(){

            public double getForce() {
                return force1DModel.getAppliedForce();
            }
        });
        this.friction = new ForceArrowGraphic(force1DPanel, SimStrings.get("ArrowSetGraphic.frictionForce"), this.laf.getFrictionForceColor(), 0, new ForceComponent(){

            public double getForce() {
                return force1DModel.getStoredFrictionForceValue();
            }
        });
        this.total = new ForceArrowGraphic(force1DPanel, SimStrings.get("ArrowSetGraphic.totalForce"), this.laf.getNetForceColor(), 60, new ForceComponent(){

            public double getForce() {
                return force1DModel.getNetForce();
            }
        });
        this.wall = new ForceArrowGraphic(force1DPanel, SimStrings.get("ArrowSetGraphic.wallForce"), this.laf.getWallForceColor(), 60, new ForceComponent(){

            public double getForce() {
                return force1DModel.getWallForce();
            }
        });
        this.addGraphic(this.applied);
        this.addGraphic(this.friction);
        this.addGraphic(this.total);
        this.addGraphic(this.wall);
    }

    private void updateForceArrows() {
        this.friction.update();
        this.applied.update();
        this.wall.update();
        this.total.update();
        this.checkTextOverlap();
    }

    private void checkTextOverlap() {
        Rectangle rectangle;
        Rectangle rectangle2;
        if (this.friction.textGraphic.isVisible() && this.applied.textGraphic.isVisible() && (rectangle2 = this.friction.textGraphic.getBounds()).intersects(rectangle = this.applied.textGraphic.getBounds())) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            int n = rectangle3.width;
            int n2 = n / 2 + 5;
            if (rectangle2.x < rectangle.x) {
                this.friction.textGraphic.setLocation(rectangle2.x - n2, this.friction.textGraphic.getY());
                this.applied.textGraphic.setLocation(rectangle.x + n2, this.applied.textGraphic.getY());
            } else {
                this.friction.textGraphic.setLocation(rectangle2.x + n2, this.friction.textGraphic.getY());
                this.applied.textGraphic.setLocation(rectangle.x - n2, this.applied.textGraphic.getY());
            }
        }
    }

    public void updateGraphics() {
        this.updateForceArrows();
    }

    class ForceArrowGraphic
    extends CompositePhetGraphic {
        private String name;
        private Color color;
        private int dy;
        private ForceComponent forceComponent;
        PhetShadowTextGraphic textGraphic;
        PhetShapeGraphic shapeGraphic;
        final Font font;
        private Arrow lastArrow;

        public ForceArrowGraphic(Component component, String string, Color color, int n, ForceComponent forceComponent) {
            super(component);
            this.font = new Font("Lucida Sans", 1, 13);
            this.name = string;
            this.color = color = Force1DUtil.transparify(color, 128);
            this.dy = n;
            this.forceComponent = forceComponent;
            this.textGraphic = new PhetShadowTextGraphic(component, this.font, string, Color.black, 1, 1, Color.yellow);
            this.shapeGraphic = new PhetShapeGraphic(component, null, color, new BasicStroke(1.0f), Color.black);
            this.addGraphic(this.shapeGraphic);
            this.addGraphic(this.textGraphic);
            this.update();
        }

        public void update() {
            double d = this.forceComponent.getForce();
            if (d == 0.0) {
                this.setVisible(false);
                return;
            }
            this.setVisible(true);
            double d2 = d * 0.5;
            Point point = ArrowSetGraphic.this.blockGraphic.getCenter();
            point.y += ((ArrowSetGraphic)ArrowSetGraphic.this).blockGraphic.computeDimension().height / 2;
            point.y -= this.dy;
            Point2D.Double double_ = new Point2D.Double(point.x, point.y);
            Point2D point2D = new Vector2D.Double(d2, 0.0).getDestination(double_);
            Arrow arrow = new Arrow(double_, point2D, ArrowSetGraphic.this.arrowHeadHeight, ArrowSetGraphic.this.arrowHeadHeight, ArrowSetGraphic.this.arrowTailWidth, 0.5, false);
            GeneralPath generalPath = arrow.getShape();
            if (this.lastArrow == null || !this.lastArrow.equals(arrow)) {
                this.shapeGraphic.setShape(generalPath);
                GeneralPath generalPath2 = arrow.getTailShape();
                double d3 = this.textGraphic.getHeight();
                double d4 = generalPath2.getBounds().getHeight();
                double d5 = generalPath2.getBounds().getY() + d4 / 2.0 - d3 / 2.0;
                this.textGraphic.setLocation(generalPath2.getBounds().x, (int)d5);
            }
            this.lastArrow = arrow;
        }
    }

    static interface ForceComponent {
        public double getForce();
    }
}

