/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common_force1d.math.Function;
import edu.colorado.phet.common_force1d.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.forces1d.model.Block;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import edu.colorado.phet.forces1d.view.ThresholdedDragAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.event.MouseInputAdapter;

public class BlockGraphic
extends CompositePhetGraphic {
    private Block block;
    private Force1DModel model;
    private ModelViewTransform2D transform2D;
    private Function.LinearFunction transform1d;
    private PhetImageGraphic graphic;
    private Force1DPanel panel;
    private Point lastCenter;
    private ThresholdedDragAdapter mouseListener;

    public BlockGraphic(Force1DPanel force1DPanel, Block block, final Force1DModel force1DModel, ModelViewTransform2D modelViewTransform2D, Function.LinearFunction linearFunction, Force1dObject force1dObject) {
        super(force1DPanel);
        this.panel = force1DPanel;
        this.block = block;
        this.model = force1DModel;
        this.transform2D = modelViewTransform2D;
        this.transform1d = linearFunction;
        this.graphic = new PhetImageGraphic((Component)force1DPanel, force1dObject.getLocation());
        this.addGraphic(this.graphic);
        this.update();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = BlockGraphic.this.getCenter();
                double d = mouseEvent.getPoint().x - point.x;
                double d2 = d / 0.5;
                force1DModel.setAppliedForce(d2);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                force1DModel.setAppliedForce(0.0);
            }
        };
        this.mouseListener = new ThresholdedDragAdapter(mouseInputAdapter, 10, 0, 1000L);
        this.addMouseInputListener(this.mouseListener);
        this.setCursorHand();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.graphic.setImage(bufferedImage);
    }

    public Dimension computeDimension() {
        return new Dimension(this.graphic.getWidth(), this.graphic.getHeight());
    }

    protected Rectangle determineBounds() {
        return super.determineBounds();
    }

    public Block getBlock() {
        return this.block;
    }

    public void update() {
        double d = this.block.getMass();
        double d2 = 0.35;
        double d3 = d / 1000.0 / 2.0 + d2;
        this.setAutoRepaint(false);
        this.setTransform(new AffineTransform());
        this.scale(d2, d3);
        Point point = this.getCenter();
        this.setLocation(point.x - this.graphic.getWidth() / 2, point.y - this.graphic.getHeight() / 2 + 5);
        this.setBoundsDirty();
        this.setAutoRepaint(true);
        if (this.lastCenter != null && !this.lastCenter.equals(point)) {
            this.autorepaint();
            this.notifyChanged();
        }
        this.lastCenter = point;
    }

    public Point getCenter() {
        Dimension dimension = this.computeDimension();
        int n = (int)this.transform1d.evaluate(this.block.getPosition());
        int n2 = this.panel.getWalkwayGraphic().getFloorY() - dimension.height / 2;
        return new Point(n, n2);
    }
}

