/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.math.Function;
import edu.colorado.phet.common_force1d.math.Vector2D;
import edu.colorado.phet.common_force1d.view.ApparatusPanel2;
import edu.colorado.phet.common_force1d.view.BasicGraphicsSetup;
import edu.colorado.phet.common_force1d.view.ContentPanel;
import edu.colorado.phet.common_force1d.view.PhetFrame;
import edu.colorado.phet.common_force1d.view.components.VerticalLayoutPanel;
import edu.colorado.phet.common_force1d.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common_force1d.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common_force1d.view.phetgraphics.BufferedPhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common_force1d.view.phetgraphics.RepaintDebugGraphic;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.common.HelpItem2;
import edu.colorado.phet.forces1d.common.LayoutUtil;
import edu.colorado.phet.forces1d.common.RelativeLocationSetter;
import edu.colorado.phet.forces1d.common.TitleLayout;
import edu.colorado.phet.forces1d.common.WiggleMe;
import edu.colorado.phet.forces1d.common.phetcomponents.PhetButton;
import edu.colorado.phet.forces1d.common.plotdevice.FloatingControl;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDevice;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceView;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.ArrowSetGraphic;
import edu.colorado.phet.forces1d.view.BlockGraphic;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.Force1DPlotDeviceView;
import edu.colorado.phet.forces1d.view.LeanerGraphic;
import edu.colorado.phet.forces1d.view.OffscreenPointerGraphic;
import edu.colorado.phet.forces1d.view.WalkwayGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class Force1DPanel
extends ApparatusPanel2 {
    private Force1DApplication module;
    private BlockGraphic blockGraphic;
    private ArrowSetGraphic arrowSetGraphic;
    private ModelViewTransform2D transform2D;
    private Function.LinearFunction walkwayTransform;
    private PlotDevice forcePlotDevice;
    private WalkwayGraphic walkwayGraphic;
    private LeanerGraphic leanerGraphic;
    private Force1DModel model;
    private PlotDeviceView forcePlotDeviceView;
    private RepaintDebugGraphic repaintDebugGraphic;
    private Force1DLookAndFeel lookAndFeel = new Force1DLookAndFeel();
    private OffscreenPointerGraphic offscreenPointerGraphic;
    private BufferedPhetGraphic backgroundGraphic;
    private PlotDevice accelPlotDevice;
    private PlotDevice velPlotDevice;
    private PlotDevice posPlotDevice;
    private WiggleMe wiggleMe;
    private Color top = new Color(230, 255, 230);
    private Color bottom = new Color(180, 200, 180);
    private FloatingControl floatingControl;
    private WiggleMe sliderWiggleMe;
    private HelpItem2 soloGoButtonHelp;
    private boolean goButtonPressed;
    private PhetGraphic floatingControlGraphic;
    private PhetGraphic checkBoxPanelGraphic;
    private boolean didLayout = false;

    public Force1DPanel(final Force1DApplication force1DApplication) throws IOException {
        super(force1DApplication.getClock());
        this.backgroundGraphic = new BufferedPhetGraphic(this, 800, 800, Color.white);
        this.backgroundGraphic.setGraphicsSetup(new BasicGraphicsSetup());
        this.module = force1DApplication;
        this.model = force1DApplication.getForceModel();
        this.addGraphicsSetup(new BasicGraphicsSetup());
        this.walkwayTransform = new Function.LinearFunction(-12.0, 12.0, 0.0, 400.0);
        this.walkwayGraphic = new WalkwayGraphic(this, force1DApplication, 21, this.walkwayTransform);
        this.blockGraphic = new BlockGraphic(this, force1DApplication.getForceModel().getBlock(), this.model, this.transform2D, this.walkwayTransform, force1DApplication.imageElementAt(0));
        this.arrowSetGraphic = new ArrowSetGraphic(this, this.blockGraphic, this.model, this.transform2D);
        this.leanerGraphic = new LeanerGraphic(this, this.blockGraphic);
        this.backgroundGraphic.addGraphic(this.walkwayGraphic);
        this.backgroundGraphic.repaintBuffer();
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.blockGraphic);
        this.addGraphic(this.leanerGraphic, 1000.0);
        this.leanerGraphic.setLocation(400, 100);
        this.addGraphic(this.arrowSetGraphic);
        int n = 3;
        this.forcePlotDeviceView = new Force1DPlotDeviceView(force1DApplication, this);
        double d = 1000.0;
        Force1DLookAndFeel force1DLookAndFeel = force1DApplication.getForce1DLookAndFeel();
        PlotDevice.ParameterSet parameterSet = new PlotDevice.ParameterSet(this, SimStrings.get("Force1DPanel.appliedForce"), this.model.getPlotDeviceModel(), this.forcePlotDeviceView, this.model.getAppliedForceDataSeries().getSmoothedDataSeries(), Color.black, new BasicStroke(10.0f), new Rectangle2D.Double(0.0, -d, this.model.getPlotDeviceModel().getMaxTime(), d * 2.0), 0.0, SimStrings.get("Force1DPanel.newtonsAbbrev"), SimStrings.get("Force1DPanel.appliedForce"), true, SimStrings.get("Force1DPanel.forceWithUnits"));
        parameterSet.setZoomRates(300, 100, 5000.0);
        this.forcePlotDevice = new PlotDevice(parameterSet, this.backgroundGraphic);
        this.forcePlotDevice.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                Force1DPanel.this.checkBoxPanelGraphic.setVisible(phetGraphic.isVisible());
            }
        });
        this.forcePlotDevice.removeDefaultDataSeries();
        this.forcePlotDevice.setAdorned(true);
        this.forcePlotDevice.setLabelText(SimStrings.get("Force1DPanel.appliedForceHTML"));
        float f = 3.0f;
        float f2 = 3.0f;
        float f3 = 3.0f;
        int n2 = 190;
        Color color = Force1DUtil.transparify(force1DLookAndFeel.getFrictionForceColor(), n2);
        Color color2 = Force1DUtil.transparify(force1DLookAndFeel.getAppliedForceColor(), n2);
        Color color3 = Force1DUtil.transparify(force1DLookAndFeel.getNetForceColor(), n2);
        int n3 = 0;
        int n4 = 1;
        this.forcePlotDevice.addDataSeries(this.model.getFrictionForceSeries(), color, SimStrings.get("ArrowSetGraphic.frictionForce"), new BasicStroke(f, n3, n4));
        this.forcePlotDevice.addDataSeries(this.model.getAppliedForceSeries().getSmoothedDataSeries(), color2, SimStrings.get("ArrowSetGraphic.appliedForce"), new BasicStroke(f2, n3, n4));
        this.forcePlotDevice.addDataSeries(this.model.getNetForceSeries(), color3, SimStrings.get("ArrowSetGraphic.totalForce"), new BasicStroke(f3, n3, n4));
        this.backgroundGraphic.addGraphic(this.forcePlotDevice);
        this.addGraphic(this.forcePlotDevice.getVerticalChartSlider());
        double d2 = 10.0;
        PlotDevice.ParameterSet parameterSet2 = new PlotDevice.ParameterSet(this, SimStrings.get("Force1DPanel.acceleration"), this.model.getPlotDeviceModel(), this.forcePlotDeviceView, this.model.getAccelerationDataSeries(), force1DLookAndFeel.getAccelerationColor(), new BasicStroke(n), new Rectangle2D.Double(0.0, -d2, this.model.getPlotDeviceModel().getMaxTime(), d2 * 2.0), 0.0, SimStrings.get("Force1DPanel.accelerationUnitsHTML"), SimStrings.get("Force1DPanel.acceleration"), false, SimStrings.get("Force1DPanel.accelerationAndUnitsHTML"));
        this.accelPlotDevice = new PlotDevice(parameterSet2, this.backgroundGraphic);
        this.backgroundGraphic.addGraphic(this.accelPlotDevice);
        double d3 = 10.0;
        PlotDevice.ParameterSet parameterSet3 = new PlotDevice.ParameterSet(this, SimStrings.get("Force1DPanel.velocity"), this.model.getPlotDeviceModel(), this.forcePlotDeviceView, this.model.getVelocityDataSeries().getSmoothedDataSeries(), force1DLookAndFeel.getVelocityColor(), new BasicStroke(n), new Rectangle2D.Double(0.0, -d3, this.model.getPlotDeviceModel().getMaxTime(), d3 * 2.0), 0.0, SimStrings.get("Force1DPanel.velocityUnits"), SimStrings.get("Force1DPanel.velocity"), false, SimStrings.get("Force1DPanel.velocityAndUnits"));
        this.velPlotDevice = new PlotDevice(parameterSet3, this.backgroundGraphic);
        this.backgroundGraphic.addGraphic(this.velPlotDevice);
        double d4 = 10.0;
        PlotDevice.ParameterSet parameterSet4 = new PlotDevice.ParameterSet(this, SimStrings.get("Force1DPanel.position"), this.model.getPlotDeviceModel(), this.forcePlotDeviceView, this.model.getPositionDataSeries().getSmoothedDataSeries(), force1DLookAndFeel.getPositionColor(), new BasicStroke(n), new Rectangle2D.Double(0.0, -d4, this.model.getPlotDeviceModel().getMaxTime(), d4 * 2.0), 0.0, SimStrings.get("Force1DPanel.positionUnits"), SimStrings.get("Force1DPanel.position"), false, SimStrings.get("Force1DPanel.positionAndUnits"));
        this.posPlotDevice = new PlotDevice(parameterSet4, this.backgroundGraphic);
        this.backgroundGraphic.addGraphic(this.posPlotDevice);
        this.forcePlotDevice.addListener(new PlotDevice.Listener(){

            public void readoutChanged(double d) {
            }

            public void valueChanged(double d) {
                Force1DPanel.this.model.setAppliedForce(d);
            }
        });
        this.model.addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                Force1DPanel.this.forcePlotDevice.setValue(Force1DPanel.this.model.getAppliedForce());
            }

            public void gravityChanged() {
            }
        });
        Font font = new Font("Lucida Sans", 0, 13);
        String string = SimStrings.get("Force1DPanel.showFTotalHTML");
        final JCheckBox jCheckBox = new JCheckBox(string, true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.setShowForceSeries(2, jCheckBox.isSelected());
            }
        });
        jCheckBox.setFont(font);
        String string2 = SimStrings.get("Force1DPanel.showFrictionHTML");
        final JCheckBox jCheckBox2 = new JCheckBox(string2, true);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.setShowForceSeries(0, jCheckBox2.isSelected());
            }
        });
        jCheckBox2.setFont(font);
        final JCheckBox jCheckBox3 = new JCheckBox(SimStrings.get("Force1DPanel.showAppliedHTML"), true);
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.setShowForceSeries(1, jCheckBox3.isSelected());
            }
        });
        jCheckBox3.setFont(font);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        ((Container)verticalLayoutPanel).add(jCheckBox);
        ((Container)verticalLayoutPanel).add(jCheckBox2);
        ((Container)verticalLayoutPanel).add(jCheckBox3);
        this.checkBoxPanelGraphic = PhetJComponent.newInstance(this, verticalLayoutPanel);
        this.floatingControl = new FloatingControl(this.forcePlotDevice.getPlotDeviceModel(), this);
        this.floatingControlGraphic = PhetJComponent.newInstance(this, this.floatingControl);
        this.floatingControlGraphic.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
                Force1DPanel.this.checkBoxPanelGraphic.setLocation(Force1DPanel.this.floatingControlGraphic.getX(), Force1DPanel.this.floatingControlGraphic.getY() + Force1DPanel.this.floatingControlGraphic.getHeight() + 2);
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
            }
        });
        this.addGraphic(this.floatingControlGraphic, Double.POSITIVE_INFINITY);
        this.addGraphic(this.checkBoxPanelGraphic, Double.POSITIVE_INFINITY);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Force1DPanel.this.requestFocus();
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    if (Force1DPanel.this.repaintDebugGraphic.isActive()) {
                        Force1DPanel.this.removeGraphic(Force1DPanel.this.repaintDebugGraphic);
                    } else {
                        Force1DPanel.this.addGraphic(Force1DPanel.this.repaintDebugGraphic, Double.POSITIVE_INFINITY);
                    }
                    Force1DPanel.this.repaintDebugGraphic.setActive(!Force1DPanel.this.repaintDebugGraphic.isActive());
                }
            }
        });
        this.repaintDebugGraphic = new RepaintDebugGraphic(this, force1DApplication.getClock());
        this.repaintDebugGraphic.setTransparency(128);
        this.repaintDebugGraphic.setActive(false);
        this.offscreenPointerGraphic = new OffscreenPointerGraphic(this, this.blockGraphic, this.walkwayGraphic);
        this.addGraphic(this.offscreenPointerGraphic, 1000.0);
        this.offscreenPointerGraphic.setLocation(400, 50);
        PhetButton phetButton = new PhetButton(this, SimStrings.get("Force1DPanel.reset"));
        phetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Resetted.");
                force1DApplication.reset();
            }
        });
        this.addGraphic(phetButton);
        TitleLayout.layout(phetButton, this.offscreenPointerGraphic);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Force1DPanel.this.forcePlotDevice.getPlotDeviceModel().setRecordMode();
                Force1DPanel.this.forcePlotDevice.getPlotDeviceModel().setPaused(false);
            }
        };
        this.blockGraphic.addMouseInputListener(mouseInputAdapter);
        this.wiggleMe = new WiggleMe((Component)this, force1DApplication.getClock(), SimStrings.get("Force1DPanel.applyForce"), this.blockGraphic);
        this.wiggleMe.setOscillationAxis(new Vector2D.Double(1.0, 0.0));
        this.addGraphic(this.wiggleMe, 10000.0);
        this.model.addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                Force1DPanel.this.wiggleMe.setVisible(false);
                Force1DPanel.this.removeGraphic(Force1DPanel.this.wiggleMe);
            }

            public void gravityChanged() {
            }
        });
        this.sliderWiggleMe = new WiggleMe((Component)this, force1DApplication.getClock(), SimStrings.get("Force1DPanel.wiggleMeText"), new WiggleMe.Target(){

            public Point getLocation() {
                int n = Force1DPanel.this.forcePlotDevice.getVerticalChartSlider().getSlider().getX() + Force1DPanel.this.sliderWiggleMe.getWidth() + 10;
                int n2 = Force1DPanel.this.forcePlotDevice.getY() + Force1DPanel.this.forcePlotDevice.getHeight() / 2;
                return new Point(n, n2);
            }
        });
        this.sliderWiggleMe.setArrow(-30.0, 5.0);
        this.forcePlotDevice.getVerticalChartSlider().getSlider().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Force1DPanel.this.sliderWiggleMe.setVisible(false);
                if (!Force1DPanel.this.goButtonPressed && force1DApplication.getForceModel().getPlotDeviceModel().isPaused()) {
                    Force1DPanel.this.soloGoButtonHelp.setVisible(true);
                }
            }
        });
        this.floatingControl.getGoButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.soloGoButtonHelp.setVisible(false);
                Force1DPanel.this.goButtonPressed = true;
            }
        });
        this.addGraphic(this.sliderWiggleMe, Double.POSITIVE_INFINITY);
        this.sliderWiggleMe.setVisible(false);
        this.accelPlotDevice.setVisible(false);
        this.velPlotDevice.setVisible(false);
        this.posPlotDevice.setVisible(false);
        this.model.getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void rewind() {
                Force1DPanel.this.updateGraphics();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Force1DPanel.this.setReferenceSize();
            }
        });
        HelpItem2 helpItem2 = new HelpItem2(this, SimStrings.get("Force1DPanel.sliderHelp"));
        helpItem2.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(this.forcePlotDevice.getVerticalChartSlider().getSliderGraphic()), 30);
        HelpItem2 helpItem22 = new HelpItem2(this, SimStrings.get("Force1DPanel.goRecordHelp"));
        PhetGraphic phetGraphic = this.getGoButtonGraphic();
        helpItem22.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(phetGraphic), 30);
        HelpItem2 helpItem23 = new HelpItem2(this, SimStrings.get("Force1DPanel.applyForceHelp"));
        helpItem23.pointUpAt(this.blockGraphic, 15);
        HelpItem2 helpItem24 = new HelpItem2(this, SimStrings.get("Force1DPanel.zoomHelp"));
        helpItem24.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(this.forcePlotDevice.getChartComponent().getMagPlusGraphic()), 30);
        HelpItem2 helpItem25 = new HelpItem2(this, SimStrings.get("Force1DPanel.typeHelp"));
        helpItem25.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(this.forcePlotDevice.getTextFieldGraphic()), 20);
        force1DApplication.getHelpManager().addGraphic(helpItem2);
        force1DApplication.getHelpManager().addGraphic(helpItem22);
        force1DApplication.getHelpManager().addGraphic(helpItem23);
        force1DApplication.getHelpManager().addGraphic(helpItem24);
        force1DApplication.getHelpManager().addGraphic(helpItem25);
        this.soloGoButtonHelp = new HelpItem2(this, SimStrings.get("Force1DPanel.pressGoHelp"));
        this.soloGoButtonHelp.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(phetGraphic), 30);
        this.addGraphic(this.soloGoButtonHelp, Double.POSITIVE_INFINITY);
        this.soloGoButtonHelp.setVisible(false);
        this.setUseOffscreenBuffer(true);
    }

    private PhetGraphic getGoButtonGraphic() {
        PhetGraphic phetGraphic = ((GraphicLayerSet)this.floatingControlGraphic).getGraphics()[1];
        return phetGraphic;
    }

    public void paint(Graphics graphics) {
        super.paintComponent(graphics);
    }

    private void setShowForceSeries(int n, boolean bl) {
        this.forcePlotDevice.setDataSeriesVisible(n, bl);
        this.repaintBuffer();
        this.repaint();
    }

    public Force1DLookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setReferenceSize() {
        super.setReferenceSize();
        this.forceLayout(this.getWidth(), this.getHeight());
        this.leanerGraphic.screenSizeChanged();
    }

    public void forceLayout(int n, int n2) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int n3;
            this.backgroundGraphic.setSize(n, n2);
            Color color = this.module.getPhetLookAndFeel().getBackgroundColor();
            this.backgroundGraphic.setBackground(color);
            int n4 = n / 6;
            int n5 = n3 = 5;
            int n6 = 0;
            int n7 = n - n3 * 2;
            this.walkwayTransform.setOutput(n5, n5 + n7);
            this.walkwayGraphic.setBounds(n5, n6, n7, n4);
            this.layoutPlots(n, n2);
            Dimension dimension = this.floatingControl.getPreferredSize();
            int n8 = 5;
            int n9 = this.getHeight() / 2 - dimension.height / 2;
            if (this.forcePlotDevice.isVisible()) {
                Rectangle rectangle = this.forcePlotDevice.getTextBox().getBounds();
                n9 = rectangle.y + rectangle.height + 10;
            }
            this.floatingControlGraphic.setLocation(n8, n9);
            this.updateGraphics();
            this.repaint();
            this.didLayout = true;
        }
    }

    public void layoutPlots(int n, int n2) {
        int n3 = n;
        int n4 = 200;
        int n5 = n3 - n4 - 25;
        int n6 = this.walkwayGraphic.getY() + this.walkwayGraphic.getHeight() + 20;
        int n7 = this.forcePlotDevice.getChart().getHorizontalTicks().getMajorTickTextBounds().height * 2;
        Rectangle rectangle = new Rectangle(n4, n6 + n7, n5, n2 - n6 - n7 * 2);
        if (rectangle.width > 0 && rectangle.height > 0) {
            LayoutUtil.LayoutElement layoutElement;
            int n8;
            int n9 = 7;
            LayoutUtil layoutUtil = new LayoutUtil(rectangle.getY(), rectangle.getHeight() + rectangle.getY(), n9);
            PlotDevice[] plotDeviceArray = new PlotDevice[]{this.forcePlotDevice, this.accelPlotDevice, this.velPlotDevice, this.posPlotDevice};
            LayoutUtil.LayoutElement[] layoutElementArray = new LayoutUtil.LayoutElement[plotDeviceArray.length];
            int n10 = plotDeviceArray[0].getButtonHeight();
            for (n8 = 0; n8 < layoutElementArray.length; ++n8) {
                layoutElement = new LayoutUtil.Dynamic();
                layoutElementArray[n8] = plotDeviceArray[n8].isVisible() ? layoutElement : new LayoutUtil.Fixed(n10);
            }
            layoutUtil.layout(layoutElementArray);
            for (n8 = 0; n8 < layoutElementArray.length; ++n8) {
                layoutElement = layoutElementArray[n8];
                if (plotDeviceArray[n8].isVisible()) {
                    plotDeviceArray[n8].setViewBounds(this.restrictBounds(rectangle, layoutElement));
                    continue;
                }
                plotDeviceArray[n8].setButtonLoc(n4, layoutElement.getMin());
            }
        }
        this.repaintBuffer();
    }

    public void repaintBuffer() {
        this.backgroundGraphic.repaintBuffer();
        this.forcePlotDevice.repaintBuffer();
        this.accelPlotDevice.repaintBuffer();
        this.velPlotDevice.repaintBuffer();
        this.posPlotDevice.repaintBuffer();
    }

    private Rectangle restrictBounds(Rectangle rectangle, LayoutUtil.LayoutElement layoutElement) {
        return new Rectangle(rectangle.x, (int)layoutElement.getMin(), rectangle.width, (int)layoutElement.getSize());
    }

    public WalkwayGraphic getWalkwayGraphic() {
        return this.walkwayGraphic;
    }

    public void updateGraphics() {
        this.arrowSetGraphic.updateGraphics();
        this.blockGraphic.update();
    }

    public void reset() {
        this.repaintBuffer();
        this.forcePlotDevice.reset();
        this.repaint(0, 0, this.getWidth(), this.getHeight());
        this.handleWiggleMes();
    }

    private void handleWiggleMes() {
        boolean bl = this.forcePlotDevice.getVerticalChartSlider().hasMoved();
        if (!bl) {
            this.sliderWiggleMe.setVisible(true);
        }
    }

    public Force1DApplication getModule() {
        return this.module;
    }

    public BlockGraphic getBlockGraphic() {
        return this.blockGraphic;
    }

    public void cursorMovedToTime(double d, int n) {
        this.model.setPlaybackIndex(n);
        this.forcePlotDevice.cursorMovedToTime(d, n);
        this.accelPlotDevice.cursorMovedToTime(d, n);
        this.velPlotDevice.cursorMovedToTime(d, n);
        this.posPlotDevice.cursorMovedToTime(d, n);
        this.updateGraphics();
    }

    public void setHelpEnabled(boolean bl) {
        if (bl) {
            this.removeGraphic(this.wiggleMe);
            this.addGraphic(this.wiggleMe, 10000.0);
            this.wiggleMe.setVisible(true);
        } else {
            this.wiggleMe.setVisible(false);
            this.removeGraphic(this.wiggleMe);
        }
    }

    public void layoutPlots() {
        this.layoutPlots(this.getWidth(), this.getHeight());
    }

    public void setChartBackground(Color color) {
        System.out.println("color = " + color.getRed() + ", " + color.getBlue() + ", " + color.getGreen());
        this.forcePlotDevice.setChartBackground(color);
        this.accelPlotDevice.setChartBackground(color);
        this.velPlotDevice.setChartBackground(color);
        this.posPlotDevice.setChartBackground(color);
        this.repaintBuffer();
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        this.setReferenceSize();
    }

    public PlotDevice getPlotDevice() {
        return this.forcePlotDevice;
    }

    public void clearData() {
        this.forcePlotDevice.clearData();
    }

    public void setPhetFrame(PhetFrame phetFrame) {
        ContentPanel contentPanel = phetFrame.getBasicPhetPanel();
    }
}

