/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.math.AbstractVector2D;
import edu.colorado.phet.common_force1d.math.Vector2D;
import edu.colorado.phet.common_force1d.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_force1d.view.util.RectangleUtils;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.ThresholdedDragAdapter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class FreeBodyDiagram
extends CompositePhetGraphic {
    private Force1DApplication module;
    private PhetGraphic background;
    private AxesGraphic axes;
    private Rectangle rect;
    private Force1DModel model;
    private ForceArrow mg;
    private ForceArrow normal;
    private ForceArrow appliedForce;
    private ForceArrow wallForce;
    private ForceArrow frictionForce;
    private ForceArrow netForce;
    private double yScale = 0.025;
    private double xScale = 0.1;
    private Force1DLookAndFeel laf;
    private boolean userClicked = false;

    public FreeBodyDiagram(JPanel jPanel, Force1DApplication force1DApplication) {
        super(jPanel);
        this.model = force1DApplication.getForceModel();
        this.module = force1DApplication;
        this.rect = new Rectangle(200, 150, 400, 400);
        this.laf = force1DApplication.getForce1DLookAndFeel();
        this.background = new PhetShapeGraphic(jPanel, this.rect, Color.white, new BasicStroke(1.0f), Color.black);
        this.addGraphic(this.background);
        this.axes = new AxesGraphic(jPanel);
        this.addGraphic(this.axes);
        this.axes.setVisible(false);
        this.mg = new ForceArrow(jPanel, this, this.laf.getWeightColor(), SimStrings.get("FreeBodyDiagram.gravity"), new Vector2D.Double(0.0, 80.0));
        this.addForceArrow(this.mg);
        this.normal = new ForceArrow(jPanel, this, this.laf.getNormalColor(), SimStrings.get("FreeBodyDiagram.normal"), new Vector2D.Double(0.0, 80.0));
        this.addForceArrow(this.normal);
        this.appliedForce = new ForceArrow(jPanel, this, this.laf.getAppliedForceColor(), SimStrings.get("FreeBodyDiagram.applied"), new Vector2D.Double());
        this.addForceArrow(this.appliedForce);
        this.frictionForce = new ForceArrow(jPanel, this, this.laf.getFrictionForceColor(), SimStrings.get("FreeBodyDiagram.friction"), new Vector2D.Double());
        this.addForceArrow(this.frictionForce);
        this.netForce = new ForceArrow(jPanel, this, this.laf.getNetForceColor(), SimStrings.get("FreeBodyDiagram.total"), new Vector2D.Double());
        this.addForceArrow(this.netForce);
        this.netForce.setOrigin(0.0, -30.0);
        this.wallForce = new ForceArrow(jPanel, this, this.laf.getWallForceColor(), SimStrings.get("FreeBodyDiagram.wall"), new Vector2D.Double());
        this.addForceArrow(this.wallForce);
        this.wallForce.setOrigin(0.0, -30.0);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FreeBodyDiagram.this.setForce(mouseEvent.getPoint());
                FreeBodyDiagram.this.userClicked = true;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                FreeBodyDiagram.this.setForce(mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                FreeBodyDiagram.this.model.setAppliedForce(0.0);
            }
        };
        ThresholdedDragAdapter thresholdedDragAdapter = new ThresholdedDragAdapter(mouseInputAdapter, 10, 0, 1000L);
        this.addMouseInputListener(thresholdedDragAdapter);
        this.setCursorHand();
    }

    private void setForce(Point point) {
        double d = point.getX();
        double d2 = d - this.getCenter().getX();
        double d3 = d2 / this.xScale;
        this.model.setAppliedForce(d3);
    }

    private void updateXForces() {
        Vector2D.Double double_ = new Vector2D.Double(this.model.getAppliedForce() * this.xScale, 0.0);
        this.appliedForce.setVector(double_);
        Vector2D.Double double_2 = new Vector2D.Double(this.model.getFrictionForce() * this.xScale, 0.0);
        this.frictionForce.setVector(double_2);
        Vector2D.Double double_3 = new Vector2D.Double(this.model.getNetForce() * this.xScale, 0.0);
        this.netForce.setVector(double_3);
        Vector2D.Double double_4 = new Vector2D.Double(this.model.getWallForce() * this.xScale, 0.0);
        this.wallForce.setVector(double_4);
    }

    private void updateMG() {
        double d = this.model.getGravity();
        double d2 = this.model.getBlock().getMass();
        Vector2D.Double double_ = new Vector2D.Double(0.0, d * d2 * this.yScale);
        AbstractVector2D abstractVector2D = double_.getScaledInstance(-1.0);
        this.mg.setVector(double_);
        this.normal.setVector(abstractVector2D);
    }

    public void addForceArrow(ForceArrow forceArrow) {
        this.addGraphic(forceArrow);
    }

    private Point2D getCenter() {
        return RectangleUtils.getCenter(this.rect);
    }

    public void updateAll() {
        this.updateXForces();
        this.updateMG();
        this.axes.update();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.rect.setBounds(n, n2, n3, n4);
        this.updateAll();
    }

    public boolean isUserClicked() {
        return this.userClicked;
    }

    public class AxesGraphic
    extends CompositePhetGraphic {
        private PhetShapeGraphic xAxis;
        private PhetShapeGraphic yAxis;
        private PhetGraphic xLabel;
        private PhetGraphic yLabel;

        public AxesGraphic(Component component) {
            super(component);
            BasicStroke basicStroke = new BasicStroke(1.0f);
            Color color = Color.black;
            this.xAxis = new PhetShapeGraphic(component, null, basicStroke, color);
            this.yAxis = new PhetShapeGraphic(component, null, basicStroke, color);
            this.addGraphic(this.xAxis);
            this.addGraphic(this.yAxis);
            Font font = new Font("Lucida Sans", 0, 16);
            this.xLabel = new HTMLGraphic(component, font, SimStrings.get("FreeBodyDiagram.fx"), Color.black);
            this.yLabel = new HTMLGraphic(component, font, SimStrings.get("FreeBodyDiagram.fy"), Color.black);
            this.addGraphic(this.xLabel);
            this.addGraphic(this.yLabel);
            this.update();
        }

        public void update() {
            Line2D.Double double_ = new Line2D.Double(((FreeBodyDiagram)FreeBodyDiagram.this).rect.x, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.height / 2, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.x + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.width, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.height / 2);
            Line2D.Double double_2 = new Line2D.Double(((FreeBodyDiagram)FreeBodyDiagram.this).rect.x + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.width / 2, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.x + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.width / 2, ((FreeBodyDiagram)FreeBodyDiagram.this).rect.y + ((FreeBodyDiagram)FreeBodyDiagram.this).rect.height);
            this.xAxis.setShape(double_);
            this.yAxis.setShape(double_2);
            this.xLabel.setLocation((int)double_.getX2() - this.xLabel.getWidth(), (int)double_.getY2());
            this.yLabel.setLocation((int)double_2.getX1() + 3, (int)double_2.getY1());
        }
    }

    public static class ForceArrow
    extends CompositePhetGraphic {
        private PhetShapeGraphic shapeGraphic;
        private PhetGraphic textGraphic;
        private FreeBodyDiagram fbd;
        private double dx;
        private double dy;
        private String name;
        private Arrow lastArrow;

        public ForceArrow(Component component, FreeBodyDiagram freeBodyDiagram, Color color, String string, Vector2D.Double double_) {
            super(component);
            this.fbd = freeBodyDiagram;
            this.name = string;
            this.shapeGraphic = new PhetShapeGraphic(component, null, Force1DUtil.transparify(color, 150), new BasicStroke(2.0f, 1, 1), Force1DUtil.transparify(Color.black, 128));
            this.addGraphic(this.shapeGraphic);
            Font font = new Font("Lucida Sans", 1, 18);
            this.textGraphic = new HTMLGraphic(component, font, string, color);
            this.addGraphic(this.textGraphic);
            this.setVector(double_);
            this.setIgnoreMouse(true);
        }

        public void setOrigin(double d, double d2) {
            this.dx = d;
            this.dy = d2;
        }

        public void setVector(AbstractVector2D abstractVector2D) {
            Point2D point2D = this.fbd.getCenter();
            point2D = new Point2D.Double(point2D.getX() + this.dx, point2D.getY() + this.dy);
            Arrow arrow = new Arrow(point2D, abstractVector2D.getDestination(point2D), 30.0, 30.0, 10.0, 0.5, true);
            GeneralPath generalPath = arrow.getShape();
            if (this.lastArrow == null || !this.lastArrow.equals(arrow)) {
                this.shapeGraphic.setShape(generalPath);
            }
            this.lastArrow = arrow;
            Rectangle rectangle = generalPath.getBounds();
            Point point = RectangleUtils.getCenter(rectangle);
            if (abstractVector2D.getX() > 0.0) {
                this.textGraphic.setLocation(rectangle.x + rectangle.width + 5, point.y - this.textGraphic.getHeight() / 2);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getX() < 0.0) {
                this.textGraphic.setLocation(rectangle.x - this.textGraphic.getWidth() - 5, point.y - this.textGraphic.getHeight() / 2);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getY() > 0.0) {
                this.textGraphic.setLocation(point.x - this.textGraphic.getWidth() / 2, rectangle.y + rectangle.height);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getY() < 0.0) {
                this.textGraphic.setLocation(point.x - this.textGraphic.getWidth() / 2, rectangle.y - this.textGraphic.getHeight());
                this.textGraphic.setVisible(true);
            } else {
                this.textGraphic.setVisible(false);
            }
            if (abstractVector2D.getMagnitude() <= 0.05) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }
    }
}

