/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.math.Vector2D;
import edu.colorado.phet.common_force1d.view.ApparatusPanel2;
import edu.colorado.phet.common_force1d.view.BasicGraphicsSetup;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.common.WiggleMe;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDevice;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.FreeBodyDiagram;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.event.MouseInputAdapter;

public class FreeBodyDiagramPanel {
    private FreeBodyDiagram freeBodyDiagram;
    private ApparatusPanel2 fbdPanel;
    private WiggleMe fbdWiggleMe;
    private PlotDevice forcePlotDevice;
    private Force1DApplication module;

    public FreeBodyDiagramPanel(Force1DApplication force1DApplication) {
        this.module = force1DApplication;
        this.fbdPanel = new ApparatusPanel2(force1DApplication.getClock()){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
            }
        };
        this.fbdPanel.setLayout(new BoxLayout(this.fbdPanel, 1));
        this.fbdPanel.addGraphicsSetup(new BasicGraphicsSetup());
        int n = 180;
        if (Toolkit.getDefaultToolkit().getScreenSize().width < 1280) {
            n = 157;
        }
        this.fbdPanel.setPreferredSize(new Dimension(n, n));
        this.freeBodyDiagram = new FreeBodyDiagram(this.fbdPanel, force1DApplication);
        this.freeBodyDiagram.setComponent(this.fbdPanel);
        this.fbdPanel.addGraphic(this.freeBodyDiagram);
        int n2 = 3;
        this.freeBodyDiagram.setBounds(n2, n2, n - 2 * n2, n - 2 * n2);
        WiggleMe.Target target = new WiggleMe.Target(){

            public Point getLocation() {
                return new Point(FreeBodyDiagramPanel.this.fbdPanel.getWidth() - 10, FreeBodyDiagramPanel.this.fbdPanel.getHeight() / 2 - FreeBodyDiagramPanel.this.fbdWiggleMe.getHeight());
            }
        };
        this.fbdWiggleMe = new WiggleMe((Component)this.fbdPanel, force1DApplication.getClock(), SimStrings.get("FreeBodyDiagramPanel.clickHelp"), target);
        this.fbdWiggleMe.setArrowColor(new Color(0, 30, 240, 128));
        this.fbdWiggleMe.setFont(new Font("Lucida Sans", 1, 14));
        this.fbdWiggleMe.setArrow(0.0, 40.0);
        this.fbdWiggleMe.setAmplitude(10.0);
        this.fbdWiggleMe.setFrequency(5.0);
        this.fbdWiggleMe.setOscillationAxis(new Vector2D.Double(1.0, 0.0));
        this.fbdWiggleMe.setVisible(false);
        force1DApplication.getForceModel().addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                FreeBodyDiagramPanel.this.fbdWiggleMe.setVisible(false);
                FreeBodyDiagramPanel.this.fbdPanel.removeGraphic(FreeBodyDiagramPanel.this.fbdWiggleMe);
            }

            public void gravityChanged() {
            }
        });
        this.forcePlotDevice = force1DApplication.getForcePanel().getPlotDevice();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FreeBodyDiagramPanel.this.forcePlotDevice.getPlotDeviceModel().setRecordMode();
                FreeBodyDiagramPanel.this.forcePlotDevice.getPlotDeviceModel().setPaused(false);
            }
        };
        this.freeBodyDiagram.addMouseInputListener(mouseInputAdapter);
        this.fbdPanel.setUseOffscreenBuffer(true);
    }

    public ApparatusPanel2 getFBDPanel() {
        return this.fbdPanel;
    }

    public void updateGraphics() {
        this.freeBodyDiagram.updateAll();
        if (this.fbdPanel.isShowing()) {
            this.fbdPanel.paint();
        }
    }

    public void setVisible(boolean bl) {
        this.fbdPanel.setVisible(bl);
    }

    public void reset() {
        if (!this.freeBodyDiagram.isUserClicked()) {
            this.fbdWiggleMe.setVisible(true);
            if (!this.containsGraphic(this.fbdWiggleMe)) {
                this.fbdPanel.addGraphic(this.fbdWiggleMe);
            }
        }
    }

    private boolean containsGraphic(PhetGraphic phetGraphic) {
        PhetGraphic[] phetGraphicArray = this.fbdPanel.getGraphic().getGraphics();
        for (int i = 0; i < phetGraphicArray.length; ++i) {
            PhetGraphic phetGraphic2 = phetGraphicArray[i];
            if (phetGraphic2 != phetGraphic) continue;
            return true;
        }
        return false;
    }
}

