/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.view.ApparatusPanel2;
import edu.colorado.phet.common_force1d.view.ControlPanel;
import edu.colorado.phet.common_force1d.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.util.BufferedImageUtils;
import edu.colorado.phet.common_force1d.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.view.FreeBodyDiagramPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FreeBodyDiagramSuite {
    private FreeBodyDiagramPanel fbdPanel;
    private JCheckBox checkBox;
    private Force1DApplication module;
    private JDialog dialog;
    private JPanel dialogContentPane;
    private ControlPanel controlPanel;
    private int dialogInsetX;
    private int dialogInsetY;
    public PhetGraphic buttonPanelGraphic;
    public ApparatusPanel2 fbdApparatusPanel;

    public FreeBodyDiagramSuite(Force1DApplication force1DApplication) {
        this.module = force1DApplication;
        this.fbdPanel = new FreeBodyDiagramPanel(force1DApplication);
        this.checkBox = new JCheckBox(SimStrings.get("FreeBodyDiagramSuite.freeBodyDiagram"), true);
        this.checkBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = FreeBodyDiagramSuite.this.checkBox.isSelected();
                FreeBodyDiagramSuite.this.fbdPanel.setVisible(bl);
                if (bl) {
                    FreeBodyDiagramSuite.this.checkBox.setVisible(false);
                }
            }
        });
        try {
            JPanel jPanel = new JPanel(new FlowLayout(1, 1, 1));
            this.fbdApparatusPanel = this.fbdPanel.getFBDPanel();
            this.fbdApparatusPanel.setLayout(null);
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("forces-1d/images/tear-20.png");
            BufferedImage bufferedImage2 = ImageLoader.loadBufferedImage("forces-1d/images/x-20.png");
            JButton jButton = new JButton(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(jPanel, bufferedImage, 14)));
            JButton jButton2 = new JButton(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(jPanel, bufferedImage2, 14)));
            jButton.setMargin(new Insets(2, 2, 2, 2));
            jButton2.setMargin(new Insets(2, 2, 2, 2));
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (FreeBodyDiagramSuite.this.dialog == null || !FreeBodyDiagramSuite.this.dialog.isVisible()) {
                        FreeBodyDiagramSuite.this.setWindowed();
                    } else {
                        FreeBodyDiagramSuite.this.closeDialog();
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FreeBodyDiagramSuite.this.fbdApparatusPanel.setVisible(false);
                    FreeBodyDiagramSuite.this.checkBox.setVisible(true);
                    FreeBodyDiagramSuite.this.checkBox.setSelected(false);
                }
            });
            this.buttonPanelGraphic = PhetJComponent.newInstance(this.fbdApparatusPanel, jPanel);
            this.fbdApparatusPanel.addGraphic(this.buttonPanelGraphic, Double.POSITIVE_INFINITY);
            Dimension dimension = jPanel.getPreferredSize();
            jPanel.setBounds(0, 0, dimension.width, dimension.height);
            this.updateButtons();
            this.fbdApparatusPanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    FreeBodyDiagramSuite.this.updateButtons();
                }

                public void componentShown(ComponentEvent componentEvent) {
                    FreeBodyDiagramSuite.this.updateButtons();
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.checkBox.setVisible(false);
    }

    private void updateButtons() {
        this.reshapeTopRight(this.fbdApparatusPanel, this.buttonPanelGraphic, 3, 3);
    }

    private void setWindowed() {
        if (this.dialog == null) {
            this.createDialog();
        }
        this.dialog.pack();
        int n = this.dialog.getWidth();
        Point point = this.controlPanel.getLocationOnScreen();
        point.x -= n;
        this.dialog.setLocation(point);
        this.dialogContentPane.add(this.fbdPanel.getFBDPanel());
        this.fbdPanel.getFBDPanel().setLocation(this.dialogInsetX, this.dialogInsetY);
        this.dialog.setVisible(true);
        this.controlPanel.invalidate();
        this.controlPanel.doLayout();
        this.controlPanel.validate();
        this.updateButtons();
    }

    private void createDialog() {
        this.dialog = new JDialog((Frame)this.module.getPhetFrame(), SimStrings.get("FreeBodyDiagramSuite.freeBodyDiagram"));
        this.dialog.setResizable(false);
        this.dialogContentPane = new JPanel(null);
        this.dialogInsetX = 15;
        this.dialogInsetY = 15;
        ApparatusPanel2 apparatusPanel2 = this.fbdPanel.getFBDPanel();
        Dimension dimension = new Dimension(apparatusPanel2.getWidth() + this.dialogInsetX * 2, apparatusPanel2.getHeight() + this.dialogInsetY * 2);
        this.dialogContentPane.setSize(dimension);
        this.dialogContentPane.setPreferredSize(dimension);
        this.dialogContentPane.add(apparatusPanel2);
        apparatusPanel2.setLocation(this.dialogInsetX, this.dialogInsetY);
        this.dialog.setContentPane(this.dialogContentPane);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FreeBodyDiagramSuite.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.controlPanel.getControlPane().setGridY(1);
        this.controlPanel.addControl(this.fbdPanel.getFBDPanel());
        this.dialog.setVisible(false);
        this.updateButtons();
        Window window = SwingUtilities.getWindowAncestor(this.controlPanel);
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.invalidate();
            jFrame.validate();
            jFrame.repaint();
        }
    }

    public Component getCheckBox() {
        return this.checkBox;
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
    }

    public void reshapeTopRight(JComponent jComponent, PhetGraphic phetGraphic, int n, int n2) {
        int n3 = jComponent.getWidth();
        Dimension dimension = phetGraphic.getSize();
        int n4 = n3 - dimension.width - n;
        int n5 = 0 + n2;
        phetGraphic.setLocation(n4, n5);
    }

    public void reset() {
        this.fbdPanel.reset();
    }

    public void handleUserInput() {
        this.fbdPanel.getFBDPanel().handleUserInput();
    }

    public void updateGraphics() {
        this.fbdPanel.updateGraphics();
    }

    public Component getFBDPanel() {
        return this.fbdPanel.getFBDPanel();
    }

    public void controlsChanged() {
        this.updateButtons();
    }
}

