/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_force1d.view.util.BufferedImageUtils;
import edu.colorado.phet.common_force1d.view.util.FrameSequence;
import edu.colorado.phet.common_force1d.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class LeanerGraphic
extends PhetImageGraphic {
    private FrameSequence animation;
    private PhetGraphic target;
    private Force1DPanel forcePanel;
    private Force1DApplication module;
    private double max = 500.0;
    private FrameSequence flippedAnimation;
    private BufferedImage standingStill;

    public LeanerGraphic(Force1DPanel force1DPanel, PhetGraphic phetGraphic) throws IOException {
        super((Component)force1DPanel, (BufferedImage)null);
        this.forcePanel = force1DPanel;
        this.target = phetGraphic;
        this.module = force1DPanel.getModule();
        this.standingStill = ImageLoader.loadBufferedImage("forces-1d/images/standing-man.png");
        this.animation = new FrameSequence("forces-1d/images/pusher-leaning/pusher-leaning", 15);
        BufferedImage[] bufferedImageArray = new BufferedImage[this.animation.getNumFrames()];
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            bufferedImageArray[i] = BufferedImageUtils.flipX(this.animation.getFrame(i));
        }
        this.flippedAnimation = new FrameSequence(bufferedImageArray);
        super.setImage(this.animation.getFrame(0));
        final long l = System.currentTimeMillis();
        phetGraphic.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
                long l2 = System.currentTimeMillis() - l;
                if (LeanerGraphic.this.module.getForceModel().getAppliedForce() != 0.0) {
                    LeanerGraphic.this.update(false);
                }
                if (l2 < 5000L) {
                    LeanerGraphic.this.update(true);
                }
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                LeanerGraphic.this.setVisible(phetGraphic.isVisible());
            }
        });
        this.module.getForceModel().addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                LeanerGraphic.this.update(false);
            }

            public void gravityChanged() {
            }
        });
        this.setIgnoreMouse(true);
        this.update(true);
    }

    private BufferedImage getFrame(boolean bl) {
        double d = Math.abs(this.module.getForceModel().getAppliedForce());
        int n = (int)((double)this.animation.getNumFrames() * d / this.max);
        if (n >= this.animation.getNumFrames()) {
            n = this.animation.getNumFrames() - 1;
        }
        if (this.module.getForceModel().getAppliedForce() == 0.0) {
            return this.standingStill;
        }
        if (bl) {
            return this.animation.getFrame(n);
        }
        return this.flippedAnimation.getFrame(n);
    }

    public void screenSizeChanged() {
        this.update(true);
    }

    private void update(boolean bl) {
        boolean bl2 = true;
        double d = this.module.getForceModel().getAppliedForce();
        if (d < 0.0) {
            bl2 = false;
        }
        BufferedImage bufferedImage = this.getFrame(bl2);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        if (bl2) {
            n = (int)(this.target.getBounds().getX() - (double)bufferedImage.getWidth()) + n3;
            n2 = this.forcePanel.getWalkwayGraphic().getFloorY() - this.getHeight();
        } else {
            n = (int)(this.target.getBounds().getX() + (double)this.target.getWidth()) - n3;
            n2 = this.forcePanel.getWalkwayGraphic().getFloorY() - this.getHeight();
        }
        if (d != 0.0 || bl) {
            this.setLocation(n, n2);
        }
        this.setImage(bufferedImage);
    }
}

