/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_force1d.math.Function;
import edu.colorado.phet.common_force1d.view.ApparatusPanel;
import edu.colorado.phet.common_force1d.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_force1d.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.common_force1d.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DApplication;
import edu.colorado.phet.forces1d.model.BoundaryCondition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class WalkwayGraphic
extends CompositePhetGraphic {
    private double treex;
    private double housex;
    private Function.LinearFunction transform;
    private PhetImageGraphic treeGraphic;
    private PhetImageGraphic cottageGraphic;
    private PhetShapeGraphic backgroundGraphic;
    private PhetShapeGraphic floorGraphic;
    private TickSetGraphic tickSetGraphic;
    private Rectangle bounds = new Rectangle();
    private int floorHeight = 6;
    private PhetImageGraphic leftWallGraphic;
    private PhetImageGraphic rightWallGraphic;

    public WalkwayGraphic(ApparatusPanel apparatusPanel, Force1DApplication force1DApplication, int n, Function.LinearFunction linearFunction) throws IOException {
        this(apparatusPanel, force1DApplication, n, -10.0, 10.0, linearFunction);
    }

    public WalkwayGraphic(ApparatusPanel apparatusPanel, final Force1DApplication force1DApplication, int n, double d, double d2, Function.LinearFunction linearFunction) throws IOException {
        super(apparatusPanel);
        this.treex = d;
        this.housex = d2;
        this.transform = linearFunction;
        this.treeGraphic = new PhetImageGraphic((Component)apparatusPanel, "forces-1d/images/tree.gif");
        this.cottageGraphic = new PhetImageGraphic((Component)apparatusPanel, "forces-1d/images/cottage.gif");
        this.backgroundGraphic = new PhetShapeGraphic(apparatusPanel, null, Color.white, new BasicStroke(1.0f), Color.black);
        this.floorGraphic = new PhetShapeGraphic(apparatusPanel, null, Color.white);
        this.tickSetGraphic = new TickSetGraphic(apparatusPanel, linearFunction);
        this.leftWallGraphic = new PhetImageGraphic(this.getComponent(), "forces-1d/images/barrier.jpg");
        this.rightWallGraphic = new PhetImageGraphic(this.getComponent(), "forces-1d/images/barrier.jpg");
        this.leftWallGraphic.setVisible(false);
        this.rightWallGraphic.setVisible(false);
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.floorGraphic);
        this.addGraphic(this.treeGraphic);
        this.addGraphic(this.cottageGraphic);
        this.addGraphic(this.leftWallGraphic);
        this.addGraphic(this.rightWallGraphic);
        this.addGraphic(this.tickSetGraphic);
        this.setCursorHand();
        this.update();
        force1DApplication.getForceModel().addBoundaryConditionListener(new BoundaryCondition.Listener(){

            public void boundaryConditionOpen() {
                try {
                    WalkwayGraphic.this.treeGraphic.setImage(ImageLoader.loadBufferedImage("forces-1d/images/tree.gif"));
                    WalkwayGraphic.this.treeGraphic.setTransform(new AffineTransform());
                    WalkwayGraphic.this.cottageGraphic.setImage(ImageLoader.loadBufferedImage("forces-1d/images/cottage.gif"));
                    WalkwayGraphic.this.cottageGraphic.setTransform(new AffineTransform());
                    WalkwayGraphic.this.treeGraphic.setVisible(true);
                    WalkwayGraphic.this.cottageGraphic.setVisible(true);
                    WalkwayGraphic.this.leftWallGraphic.setVisible(false);
                    WalkwayGraphic.this.rightWallGraphic.setVisible(false);
                    force1DApplication.getForcePanel().repaintBuffer();
                    WalkwayGraphic.this.setBoundsDirty();
                    WalkwayGraphic.this.autorepaint();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            public void boundaryConditionWalls() {
                WalkwayGraphic.this.leftWallGraphic.setVisible(true);
                WalkwayGraphic.this.rightWallGraphic.setVisible(true);
                WalkwayGraphic.this.treeGraphic.setVisible(false);
                WalkwayGraphic.this.cottageGraphic.setVisible(false);
                force1DApplication.getForcePanel().repaintBuffer();
                WalkwayGraphic.this.setBoundsDirty();
                WalkwayGraphic.this.autorepaint();
            }
        });
    }

    public int getFloorY() {
        return this.bounds.height - this.floorHeight;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
        this.update();
    }

    private void update() {
        Rectangle rectangle = new Rectangle(this.bounds);
        rectangle.height = this.bounds.height - this.floorHeight;
        this.backgroundGraphic.setShape(rectangle);
        Color color = new Color(150, 120, 255);
        this.backgroundGraphic.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.y + rectangle.height, Color.white));
        Color color2 = new Color(100, 100, 255);
        Rectangle rectangle2 = new Rectangle(this.bounds);
        rectangle2.y = this.bounds.y + this.bounds.height - this.floorHeight;
        rectangle2.height = this.bounds.y + this.bounds.height - rectangle2.y;
        this.floorGraphic.setPaint(new GradientPaint(rectangle2.x, rectangle2.y, color2, rectangle2.x, rectangle2.y + rectangle2.height, Color.white));
        this.floorGraphic.setShape(rectangle2);
        this.tickSetGraphic.setY(rectangle2.y);
        this.tickSetGraphic.update();
        this.treeGraphic.setLocation((int)this.transform.evaluate(this.treex) - this.treeGraphic.getWidth() / 2, rectangle2.y - this.treeGraphic.getHeight());
        this.cottageGraphic.setLocation((int)this.transform.evaluate(this.housex) - this.cottageGraphic.getWidth() / 2, rectangle2.y - this.cottageGraphic.getHeight());
        this.leftWallGraphic.setLocation(this.bounds.x, this.bounds.y);
        this.leftWallGraphic.setTransform(new AffineTransform());
        this.leftWallGraphic.scale((this.transform.evaluate(this.treex) - (double)this.bounds.x) / (double)this.leftWallGraphic.getImage().getWidth(), this.bounds.getHeight() / (double)this.leftWallGraphic.getImage().getHeight());
        this.rightWallGraphic.setLocation((int)this.transform.evaluate(this.housex), 0);
        this.rightWallGraphic.setTransform(new AffineTransform());
        double d = (double)(this.bounds.x + this.bounds.width) - this.transform.evaluate(this.housex);
        this.rightWallGraphic.scale(d / (double)this.rightWallGraphic.getImage().getWidth(), this.bounds.getHeight() / (double)this.rightWallGraphic.getImage().getHeight());
        this.setBoundsDirty();
        this.repaint();
    }

    public static class TickGraphic
    extends CompositePhetGraphic {
        private double modelx;
        private Function.LinearFunction transform;
        private String text;
        private int y = 134;
        private PhetShapeGraphic shapeGraphic;
        private Font font = new Font("Lucida Sans", 1, 16);
        private PhetTextGraphic textGraphic;

        public TickGraphic(Component component, double d, Function.LinearFunction linearFunction, String string) {
            super(component);
            this.modelx = d;
            this.transform = linearFunction;
            this.text = string;
            this.shapeGraphic = new PhetShapeGraphic(component, null, new BasicStroke(1.0f), Color.black);
            this.addGraphic(this.shapeGraphic);
            this.textGraphic = new PhetTextGraphic(component, this.font, string, Color.black, 0, 0);
            this.addGraphic(this.textGraphic);
        }

        public void update() {
            int n = (int)this.transform.evaluate(this.modelx);
            int n2 = 5;
            Line2D.Double double_ = new Line2D.Double(n, this.y, n, this.y + n2);
            this.shapeGraphic.setShape(double_);
            this.textGraphic.setLocation(n - this.textGraphic.getWidth() / 2, this.y + n2);
        }

        public void setY(int n) {
            this.y = n;
        }
    }

    public static class TickSetGraphic
    extends CompositePhetGraphic {
        private int numTickMarks = 11;
        private DecimalFormat format = new DecimalFormat("##");
        ArrayList graphicList = new ArrayList();

        public TickSetGraphic(Component component, Function.LinearFunction linearFunction) {
            super(component);
            double d = -10.0;
            double d2 = -d;
            double d3 = d2 - d;
            double d4 = d3 / (double)(this.numTickMarks - 1);
            for (int i = 0; i < this.numTickMarks; ++i) {
                double d5 = d + (double)i * d4;
                String string = this.format.format(d5);
                if (string.equals("0")) {
                    string = SimStrings.get("WalkwayGraphic.zeroMeters");
                }
                TickGraphic tickGraphic = new TickGraphic(component, d5, linearFunction, string);
                this.graphicList.add(tickGraphic);
                this.addGraphic(tickGraphic);
            }
        }

        public void update() {
            for (int i = 0; i < this.graphicList.size(); ++i) {
                TickGraphic tickGraphic = (TickGraphic)this.graphicList.get(i);
                tickGraphic.update();
            }
        }

        public void setY(int n) {
            for (int i = 0; i < this.graphicList.size(); ++i) {
                TickGraphic tickGraphic = (TickGraphic)this.graphicList.get(i);
                tickGraphic.setY(n);
            }
        }
    }
}

