/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.resources;

import edu.colorado.phet.common.phetcommon.resources.DefaultResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.IResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetProperties;
import java.util.Locale;

public class PhetResources {
    private final String projectName;
    private final Locale locale;
    private final PhetProperties localizedProperties;
    private final PhetProperties projectProperties;
    private final IResourceLoader resourceLoader;
    private final String rootDirectoryName;

    public static PhetResources forProject(String string) {
        return PhetResources.forProject(string, PhetResources.readLocale());
    }

    public static PhetResources forProject(String string, Locale locale) {
        return new PhetResources(string, locale, new DefaultResourceLoader());
    }

    protected PhetResources(String string, Locale locale, IResourceLoader iResourceLoader) {
        this.projectName = string;
        this.rootDirectoryName = string;
        this.locale = locale;
        this.resourceLoader = iResourceLoader;
        String string2 = string + ".properties";
        this.projectProperties = iResourceLoader.exists(this.rootDirectoryName + '/' + string2) ? this.getProperties(string2) : new PhetProperties();
        String string3 = "localization/" + string + "-strings";
        this.localizedProperties = this.getProperties(string3);
    }

    private static Locale readLocale() {
        Locale locale = Locale.getDefault();
        String string = System.getProperty("javaws.phet.locale");
        if (string != null) {
            locale = new Locale(string);
        }
        return locale;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public PhetProperties getProjectProperties() {
        return this.projectProperties;
    }

    public PhetProperties getProperties(String string) {
        return this.resourceLoader.getProperties(this.rootDirectoryName + '/' + string, this.locale);
    }
}

