/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Arrow {
    private GeneralPath arrowPath = new GeneralPath();
    private GeneralPath headShape = new GeneralPath();
    private GeneralPath tailShape = new GeneralPath();
    private Point2D tailLocation;
    private Point2D tipLocation;
    private double headHeight;
    private double headWidth;
    private double tailWidth;
    private double fractionalHeadHeight;
    private boolean scaleTailToo;
    private AbstractVector2D direction;
    private AbstractVector2D norm;
    boolean isHeadDynamic = false;

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Arrow) {
            Arrow arrow = (Arrow)object;
            bl = arrow.tailLocation.equals(this.tailLocation) && arrow.tipLocation.equals(this.tipLocation) && arrow.headHeight == this.headHeight && arrow.headWidth == this.headWidth && arrow.tailWidth == this.tailWidth && arrow.isHeadDynamic == this.isHeadDynamic;
        }
        return bl;
    }

    public Arrow(Point2D point2D, Point2D point2D2, double d, double d2, double d3, double d4, boolean bl) {
        this.fractionalHeadHeight = d4;
        this.scaleTailToo = bl;
        this.isHeadDynamic = true;
        this.init(point2D, point2D2, d, d2, d3);
        this.computeArrow();
    }

    void init(Point2D point2D, Point2D point2D2, double d, double d2, double d3) {
        this.tailLocation = point2D;
        this.tipLocation = point2D2;
        this.headHeight = d;
        this.headWidth = d2;
        this.tailWidth = d3;
    }

    private void computeArrow() {
        if (this.tailLocation.distance(this.tipLocation) == 0.0) {
            return;
        }
        ImmutableVector2D.Double double_ = new ImmutableVector2D.Double(this.tipLocation);
        ImmutableVector2D.Double double_2 = new ImmutableVector2D.Double(this.tailLocation);
        AbstractVector2D abstractVector2D = double_.getSubtractedInstance(double_2);
        if (abstractVector2D.getMagnitude() == 0.0) {
            return;
        }
        this.direction = abstractVector2D.getNormalizedInstance();
        double d = this.tipLocation.distance(this.tailLocation);
        double d2 = this.headHeight;
        double d3 = this.headWidth;
        double d4 = this.tailWidth;
        if (this.isHeadDynamic && d < this.headHeight / this.fractionalHeadHeight) {
            d2 = d * this.fractionalHeadHeight;
            if (this.scaleTailToo) {
                d4 = this.tailWidth * d2 / this.headHeight;
                d3 = this.headWidth * d2 / this.headHeight;
            }
        } else if (d < this.headHeight) {
            throw new RuntimeException("headHeight is bigger than arrow length: length=" + d + " headHeight=" + this.headHeight);
        }
        this.norm = this.direction.getNormalVector();
        AbstractVector2D.Double double_3 = this.getPoint(-1.0 * d2, -d3 / 2.0);
        AbstractVector2D.Double double_4 = this.getPoint(-1.0 * d2, d3 / 2.0);
        AbstractVector2D.Double double_5 = this.getPoint(-1.0 * d2, -d4 / 2.0);
        AbstractVector2D.Double double_6 = this.getPoint(-1.0 * d2, d4 / 2.0);
        AbstractVector2D.Double double_7 = this.getPoint(-1.0 * d, -d4 / 2.0);
        AbstractVector2D.Double double_8 = this.getPoint(-1.0 * d, d4 / 2.0);
        this.arrowPath.reset();
        this.arrowPath.moveTo((float)double_.getX(), (float)double_.getY());
        this.lineTo(this.arrowPath, double_3);
        this.lineTo(this.arrowPath, double_5);
        this.lineTo(this.arrowPath, double_7);
        this.lineTo(this.arrowPath, double_8);
        this.lineTo(this.arrowPath, double_6);
        this.lineTo(this.arrowPath, double_4);
        this.lineTo(this.arrowPath, double_);
        this.headShape.reset();
        this.headShape.moveTo((float)double_.getX(), (float)double_.getY());
        this.lineTo(this.headShape, double_3);
        this.lineTo(this.headShape, double_4);
        this.lineTo(this.headShape, double_);
        this.tailShape.reset();
        this.tailShape.moveTo((float)double_5.getX(), (float)double_5.getY());
        this.lineTo(this.tailShape, double_7);
        this.lineTo(this.tailShape, double_8);
        this.lineTo(this.tailShape, double_6);
        this.lineTo(this.tailShape, double_5);
    }

    private void lineTo(GeneralPath generalPath, AbstractVector2D.Double double_) {
        generalPath.lineTo((float)double_.getX(), (float)double_.getY());
    }

    private AbstractVector2D.Double getPoint(double d, double d2) {
        AbstractVector2D abstractVector2D = this.direction.getScaledInstance(d).getAddedInstance(this.norm.getScaledInstance(d2));
        ImmutableVector2D.Double double_ = new ImmutableVector2D.Double(abstractVector2D.getX() + this.tipLocation.getX(), abstractVector2D.getY() + this.tipLocation.getY());
        return double_;
    }

    public GeneralPath getShape() {
        return this.arrowPath;
    }
}

