/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphics2D;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.common.phetgraphics.view.util.TransformManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;

public class ApparatusPanel2
extends ApparatusPanel
implements ClockListener {
    private TransformManager transformManager;
    private PaintStrategy paintStrategy;
    private ArrayList rectangles;
    private Rectangle repaintArea;
    private ScaledComponentLayout scaledComponentLayout;
    private IClock clock;

    private void saveLocation(Component component) {
        this.scaledComponentLayout.saveLocation(component);
    }

    public Component add(Component component) {
        this.saveLocation(component);
        return super.add(component);
    }

    public void add(Component component, Object object) {
        this.saveLocation(component);
        super.add(component, object);
    }

    public Component add(Component component, int n) {
        this.saveLocation(component);
        return super.add(component, n);
    }

    public Component add(String string, Component component) {
        this.saveLocation(component);
        return super.add(string, component);
    }

    public boolean isUseOffscreenBuffer() {
        return this.paintStrategy instanceof OffscreenBufferStrategy;
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.addRectangleToRepaintList(n, n2, n3, n4);
    }

    public void repaint() {
        if (this.clock != null && this.clock.isPaused()) {
            super.repaint();
        }
    }

    private void addRectangleToRepaintList(int n, int n2, int n3, int n4) {
        if (n4 > 0 && n3 > 0) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.rectangles.add(rectangle);
        }
    }

    public void repaint(long l) {
    }

    protected void paintComponent(Graphics graphics) {
        super.doPaintSuper(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D = new PhetGraphics2D(graphics2D);
        if (this.repaintArea == null) {
            this.repaintArea = this.getBounds();
        }
        graphics2D.setBackground(super.getBackground());
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setup(graphics2D);
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        this.paintStrategy.render(graphics2D, this.transformManager.getGraphicTx());
        graphicsState.restoreGraphics();
        super.drawBorder(graphics2D);
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    static class ScaledComponentLayout {
        private HashMap componentOrgLocationsMap;

        public void saveLocation(Component component) {
            this.componentOrgLocationsMap.put(component, new Point(component.getLocation()));
        }
    }

    public class OffscreenBufferStrategy
    implements PaintStrategy {
        private BufferedImage bImg;
        protected ApparatusPanel2 apparatusPanel2;
        private AffineTransform IDENTITY;
        private final /* synthetic */ ApparatusPanel2 this$0;

        public void render(Graphics2D graphics2D, AffineTransform affineTransform) {
            if (this.bImg == null) {
                this.componentResized();
            }
            if (this.bImg != null) {
                Graphics2D graphics2D2 = (Graphics2D)this.bImg.getGraphics();
                graphics2D2.setColor(this.apparatusPanel2.getBackground());
                graphics2D2.fillRect(this.bImg.getMinX(), this.bImg.getMinY(), this.bImg.getWidth(), this.bImg.getHeight());
                this.this$0.setup(graphics2D2);
                graphics2D2.transform(affineTransform);
                this.apparatusPanel2.getGraphic().paint(graphics2D2);
                graphics2D.drawImage(this.bImg, this.IDENTITY, this.apparatusPanel2);
                graphics2D2.dispose();
            }
        }

        public void componentResized() {
            Rectangle rectangle = new Rectangle(this.this$0.getWidth(), this.this$0.getHeight());
            if (rectangle.width > 0 && rectangle.height > 0) {
                this.bImg = new BufferedImage(rectangle.width, rectangle.height, 1);
            }
        }
    }

    static interface PaintStrategy {
        public void render(Graphics2D var1, AffineTransform var2);
    }
}

