/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common.phetgraphics.view.util.CompositeKeyListener;
import edu.colorado.phet.common.phetgraphics.view.util.CompositeMouseInputListener;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Stack;

public abstract class PhetGraphic {
    public static boolean SKIP_RECTANGLE_COMPUTATION = false;
    private Point location = new Point();
    private Point registrationPoint = new Point();
    private AffineTransform transform = new AffineTransform();
    private Rectangle lastBounds = new Rectangle();
    private Rectangle bounds = new Rectangle();
    private Component component;
    private boolean visible = true;
    private boolean boundsDirty = true;
    private RenderingHints renderingHints;
    private Stack graphicsStates = new Stack();
    private GraphicLayerSet parent;
    private Shape clip;
    protected CompositeMouseInputListener mouseInputListener = new CompositeMouseInputListener();
    protected CompositeKeyListener keyListener = new CompositeKeyListener();
    private ArrayList listeners = new ArrayList();
    private boolean ignoreMouse = false;
    private boolean autorepaint = true;
    AffineTransform netUtilTx = new AffineTransform();
    AffineTransform xlateUtilTx = new AffineTransform();
    private boolean clippingDisabled = false;

    protected PhetGraphic(Component component) {
        this.component = component;
    }

    protected PhetGraphic() {
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setParent(GraphicLayerSet graphicLayerSet) {
        this.parent = graphicLayerSet;
    }

    protected void saveGraphicsState(Graphics2D graphics2D) {
        this.graphicsStates.push(new GraphicsState(graphics2D));
    }

    protected void restoreGraphicsState() {
        if (!this.graphicsStates.empty()) {
            GraphicsState graphicsState = (GraphicsState)this.graphicsStates.pop();
            graphicsState.restoreGraphics();
        }
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    protected void updateGraphicsState(Graphics2D graphics2D) {
        RenderingHints renderingHints;
        if (this.clip != null) {
            graphics2D.setClip(this.clip);
        }
        if ((renderingHints = this.getRenderingHints()) != null) {
            graphics2D.addRenderingHints(renderingHints);
        }
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.forceRepaint();
            this.fireVisibilityChanged();
            if (!bl && this.parent != null) {
                this.parent.childBecameInvisible(this);
            }
        }
    }

    protected void fireVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PhetGraphicListener phetGraphicListener = (PhetGraphicListener)this.listeners.get(i);
            phetGraphicListener.phetGraphicVisibilityChanged(this);
        }
    }

    public boolean isVisible() {
        if (this.parent != null) {
            return this.parent.isVisible() && this.visible;
        }
        return this.visible;
    }

    public void setRegistrationPoint(Point point) {
        this.setRegistrationPoint(point.x, point.y);
    }

    public void setRegistrationPoint(int n, int n2) {
        this.registrationPoint.setLocation(n, n2);
        this.setBoundsDirty();
        this.autorepaint();
    }

    public AffineTransform getNetTransform() {
        this.netUtilTx.setToIdentity();
        this.xlateUtilTx.setToTranslation(-this.registrationPoint.x, -this.registrationPoint.y);
        this.netUtilTx.preConcatenate(this.xlateUtilTx);
        this.netUtilTx.preConcatenate(this.transform);
        this.xlateUtilTx.setToTranslation(this.location.x, this.location.y);
        this.netUtilTx.preConcatenate(this.xlateUtilTx);
        if (this.parent != null) {
            AffineTransform affineTransform = this.parent.getNetTransform();
            this.netUtilTx.preConcatenate(affineTransform);
        }
        return this.netUtilTx;
    }

    protected abstract Rectangle determineBounds();

    public Rectangle getBounds() {
        this.syncBounds();
        return this.bounds;
    }

    public void setBoundsDirty() {
        this.boundsDirty = true;
    }

    public boolean contains(int n, int n2) {
        if (this.isVisible()) {
            this.syncBounds();
            return this.bounds != null && this.bounds.contains(n, n2);
        }
        return false;
    }

    protected void syncBounds() {
        if (this.boundsDirty) {
            this.rebuildBounds();
            this.boundsDirty = false;
            if (!RectangleUtils.areEqual(this.lastBounds, this.bounds)) {
                this.notifyChanged();
            }
        }
    }

    private void rebuildBounds() {
        Cloneable cloneable;
        this.lastBounds.setBounds(this.bounds);
        Rectangle rectangle = this.determineBounds();
        if (this.clip != null && rectangle != null) {
            cloneable = this.clip.getBounds();
            rectangle = rectangle.intersects((Rectangle)cloneable) ? rectangle.intersection((Rectangle)cloneable) : null;
        }
        if (rectangle != null) {
            this.bounds.setBounds(rectangle);
        } else {
            cloneable = this.getNetTransform();
            Point2D.Double double_ = new Point2D.Double();
            ((AffineTransform)cloneable).transform(this.getLocation(), double_);
            this.bounds.setBounds((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), 0, 0);
        }
    }

    public void setLocation(int n, int n2) {
        if (this.location.x != n || this.location.y != n2) {
            this.location.setLocation(n, n2);
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    public Point getLocation() {
        return new Point(this.location);
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    protected void notifyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PhetGraphicListener phetGraphicListener = (PhetGraphicListener)this.listeners.get(i);
            phetGraphicListener.phetGraphicChanged(this);
        }
    }

    public int numMouseInputListeners() {
        return this.mouseInputListener.numMouseInputListeners();
    }

    public boolean getIgnoreMouse() {
        return this.ignoreMouse;
    }

    public void fireMouseClicked(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseClicked(mouseEvent);
        }
    }

    public void fireMousePressed(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mousePressed(mouseEvent);
        }
    }

    public void fireMouseReleased(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseReleased(mouseEvent);
        }
    }

    public void fireMouseEntered(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseEntered(mouseEvent);
        }
    }

    public void fireMouseExited(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseExited(mouseEvent);
        }
    }

    public void fireMouseExitedBecauseInvisible(MouseEvent mouseEvent) {
        this.mouseInputListener.mouseExited(mouseEvent);
    }

    public void fireMouseDragged(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseDragged(mouseEvent);
        }
    }

    public void fireMouseMoved(MouseEvent mouseEvent) {
        if (this.isVisible()) {
            this.mouseInputListener.mouseMoved(mouseEvent);
        }
    }

    public abstract void paint(Graphics2D var1);

    public void autorepaint() {
        if (this.autorepaint) {
            this.repaint();
        }
    }

    public void repaint() {
        if (this.isVisible()) {
            this.forceRepaint();
        }
    }

    protected void forceRepaint() {
        this.syncBounds();
        if (SKIP_RECTANGLE_COMPUTATION) {
            return;
        }
        if (this.lastBounds != null) {
            this.component.repaint(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        }
        if (this.bounds != null) {
            this.component.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    public void fireKeyTyped(KeyEvent keyEvent) {
        if (this.isVisible()) {
            this.keyListener.keyTyped(keyEvent);
        }
    }

    public void fireKeyPressed(KeyEvent keyEvent) {
        if (this.isVisible()) {
            this.keyListener.keyPressed(keyEvent);
        }
    }

    public void fireKeyReleased(KeyEvent keyEvent) {
        if (this.isVisible()) {
            this.keyListener.keyReleased(keyEvent);
        }
    }

    public void gainedKeyFocus() {
    }

    public void lostKeyFocus() {
    }
}

