/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class PhetShadowTextGraphic
extends PhetGraphic {
    private PhetTextGraphic foreground;
    private PhetTextGraphic background;

    public PhetShadowTextGraphic(Component component, String string, Font font, int n, int n2, Color color, int n3, int n4, Color color2) {
        super(component);
        this.foreground = new PhetTextGraphic(component, font, string, color, 0, 0);
        this.background = new PhetTextGraphic(component, font, string, color2, 0 + n3, 0 + n4);
        this.setLocation(n, n2);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            graphics2D.transform(this.getNetTransform());
            this.background.paint(graphics2D);
            this.foreground.paint(graphics2D);
            super.restoreGraphicsState();
        }
    }

    protected Rectangle determineBounds() {
        Rectangle rectangle = this.foreground.getBounds();
        Rectangle rectangle2 = this.background.getBounds();
        if (rectangle == null && rectangle2 == null) {
            return null;
        }
        if (rectangle == null) {
            return rectangle2;
        }
        if (rectangle2 == null) {
            return rectangle;
        }
        Rectangle2D rectangle2D = this.foreground.getBounds().createUnion(this.background.getBounds());
        rectangle2D = this.getNetTransform().createTransformedShape(rectangle2D).getBounds2D();
        return RectangleUtils.toRectangle(rectangle2D);
    }

    public PhetShadowTextGraphic() {
    }
}

