/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motion2d;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.motion2d.Motion2DApplet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Motion2DApplication {
    public static void main(final String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SimStrings.getInstance().init(stringArray, "motion-2d/localization/motion-2d-strings");
                    new PhetLookAndFeel().initLookAndFeel();
                    Motion2DApplet motion2DApplet = new Motion2DApplet();
                    motion2DApplet.init();
                    JFrame jFrame = new JFrame(SimStrings.getInstance().getString("Motion2dApplication.title") + " (" + PhetApplicationConfig.getVersion("motion-2d").formatForTitleBar() + ")");
                    jFrame.setContentPane(motion2DApplet);
                    jFrame.setSize(800, 500);
                    Motion2DApplication.centerFrameOnScreen(jFrame);
                    jFrame.setDefaultCloseOperation(3);
                    jFrame.repaint();
                    SwingUtilities.invokeLater(new Repaint(motion2DApplet));
                    jFrame.setVisible(true);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private static void centerFrameOnScreen(JFrame jFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width - jFrame.getWidth();
        int n2 = dimension.height - jFrame.getHeight();
        jFrame.setBounds(n / 2, n2 / 2, jFrame.getWidth(), jFrame.getHeight());
    }

    static final class Repaint
    implements Runnable {
        Component c;

        public Repaint(Component component) {
            this.c = component;
        }

        public void run() {
            this.c.repaint();
            this.c.validate();
        }
    }
}

