/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motion2d;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.motion2d.Motion2DPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Motion2DControlFrame
extends JFrame
implements ChangeListener {
    private JSlider timeStepBar;
    private JSlider velFactorBar;
    private JSlider accFactorBar;
    private TextField field5;
    private TextField field6;
    private Motion2DPanel myJP;

    public Motion2DControlFrame(Motion2DPanel motion2DPanel) {
        super(SimStrings.getInstance().getString("VAScrolls.SliderControlTitle"));
        Container container = this.getContentPane();
        this.myJP = motion2DPanel;
        this.setSize(400, 120);
        this.timeStepBar = new JSlider(0, 3, 50, motion2DPanel.getTimeStep());
        this.velFactorBar = new JSlider(0, 1, 10, (int)motion2DPanel.getVelFactor());
        this.accFactorBar = new JSlider(0, 2, 36, (int)motion2DPanel.getAccFactor());
        String string = SimStrings.getInstance().getString("VAScrolls.VelocityScaleLabel") + " " + new Integer((int)motion2DPanel.getVelFactor()).toString() + SimStrings.getInstance().getString("VAScrolls.ScaleSuffix");
        this.field5 = new TextField(string, 3);
        String string2 = SimStrings.getInstance().getString("VAScrolls.AccelerationScaleLabel") + " " + new Integer((int)motion2DPanel.getAccFactor()).toString() + SimStrings.getInstance().getString("VAScrolls.ScaleSuffix");
        this.field6 = new TextField(string2, 3);
        this.field5.setEditable(false);
        this.field6.setEditable(false);
        this.field5.setBackground(Color.white);
        this.field6.setBackground(Color.white);
        container.setLayout(new GridLayout(3, 2, 10, 5));
        container.add(this.timeStepBar);
        container.add(new JLabel("Time Scale"));
        container.add(this.velFactorBar);
        container.add(this.field5);
        container.add(this.accFactorBar);
        container.add(this.field6);
        this.timeStepBar.addChangeListener(this);
        this.velFactorBar.addChangeListener(this);
        this.accFactorBar.addChangeListener(this);
        this.addWindowListener(new MyWindowAdapter());
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                Motion2DControlFrame.this.requestFocus();
            }
        });
        this.setVisible(true);
        this.requestFocus();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.timeStepBar) {
            int n = this.timeStepBar.getValue();
            this.myJP.setTimeStep(n);
        } else if (changeEvent.getSource() == this.velFactorBar) {
            int n = this.velFactorBar.getValue();
            this.field5.setText(SimStrings.getInstance().getString("VAScrolls.VelocityScaleLabel") + " " + n + SimStrings.getInstance().getString("VAScrolls.ScaleSuffix"));
            this.myJP.setVelFactor(n);
        } else if (changeEvent.getSource() == this.accFactorBar) {
            int n = this.accFactorBar.getValue();
            this.field6.setText(SimStrings.getInstance().getString("VAScrolls.AccelerationScaleLabel") + " " + n + SimStrings.getInstance().getString("VAScrolls.ScaleSuffix"));
            this.myJP.setAccFactor(n);
        }
    }

    public JSlider getTimeStepBar() {
        return this.timeStepBar;
    }

    public JSlider getVelFactorBar() {
        return this.velFactorBar;
    }

    public JSlider getAccFactorBar() {
        return this.accFactorBar;
    }

    class MyWindowAdapter
    extends WindowAdapter {
        MyWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Motion2DControlFrame.this.myJP.getMoreButton().setEnabled(true);
        }
    }
}

