/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motion2d;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.motion2d.Motion2DApplet;
import edu.colorado.phet.motion2d.Motion2DArrow;
import edu.colorado.phet.motion2d.Motion2DControlFrame;
import edu.colorado.phet.motion2d.Motion2DModel;
import edu.colorado.phet.motion2d.MotionPanel;
import edu.colorado.phet.motion2d.WiggleMe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;

public class Motion2DPanel
extends JPanel
implements MouseMotionListener,
ActionListener,
MouseListener {
    private Motion2DApplet myGui;
    private MotionPanel motionPanel1;
    private int xNow;
    private int yNow;
    private int avgXMid;
    private int avgYMid;
    private int xVel;
    private int yVel;
    private Color myGreen;
    private int nAInit;
    private int nGroupInit;
    private int timeStep;
    private double velFactor;
    private double accFactor;
    private int radius = 9;
    JLabel btnLabel;
    JRadioButton vButton;
    JRadioButton aButton;
    JRadioButton bothButton;
    JRadioButton neitherButton;
    JButton moreButton;
    private int buttonFlag;
    private Motion2DModel motion2DModel;
    private Motion2DControlFrame motion2DControlFrame;
    private Motion2DArrow motion2DArrow;
    private boolean antialias = true;
    private Timer timer;
    private ButtonGroup buttonGroup;
    private WiggleMe wiggleMe;
    private Timer wiggleMeTimer;

    public Motion2DPanel(Motion2DApplet motion2DApplet) {
        this.myGui = motion2DApplet;
        this.myGreen = new Color(0, 150, 0);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.orange);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.orange);
        this.nAInit = 10;
        this.nGroupInit = 5;
        this.timeStep = 10;
        this.velFactor = 5.0;
        this.accFactor = 6.0;
        this.xNow = 130;
        this.yNow = 100;
        this.motion2DModel = new Motion2DModel(this.nAInit, this.nGroupInit);
        this.motion2DControlFrame = new Motion2DControlFrame(this);
        this.motion2DControlFrame.setVisible(false);
        this.motionPanel1 = new MotionPanel(this, this.motion2DModel, motion2DApplet.getWidth(), motion2DApplet.getHeight());
        this.motionPanel1.launchMotionPanel();
        this.motion2DArrow = new Motion2DArrow();
        this.motion2DModel.addPointAndUpdate(this.xNow, this.yNow);
        this.buttonFlag = 4;
        this.setBackground(Color.yellow);
        this.btnLabel = new JLabel(SimStrings.getInstance().getString("Motion2DPanel.VelocityAccelerationLabel"));
        this.btnLabel.setBackground(Color.yellow);
        this.vButton = new JRadioButton(SimStrings.getInstance().getString("Motion2DPanel.ShowVelocityRadioButton"), false);
        this.aButton = new JRadioButton(SimStrings.getInstance().getString("Motion2DPanel.ShowAccelerationRadioButton"), false);
        this.bothButton = new JRadioButton(SimStrings.getInstance().getString("Motion2DPanel.ShowBothRadioButton"), true);
        this.neitherButton = new JRadioButton(SimStrings.getInstance().getString("Motion2DPanel.ShowNeitherRadioButton"), false);
        this.buttonGroup = new ButtonGroup();
        this.setup(this.vButton);
        this.setup(this.aButton);
        this.setup(this.bothButton);
        this.setup(this.neitherButton);
        this.moreButton = new JButton(SimStrings.getInstance().getString("Motion2DPanel.MoreControlsButton"));
        jPanel.add(this.btnLabel);
        jPanel.add(this.vButton);
        jPanel.add(this.aButton);
        jPanel.add(this.bothButton);
        jPanel.add(this.neitherButton);
        jPanel2.add(this.motionPanel1);
        jPanel2.add(this.moreButton);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "South");
        this.vButton.addActionListener(this);
        this.aButton.addActionListener(this);
        this.bothButton.addActionListener(this);
        this.moreButton.addActionListener(this);
        this.neitherButton.addActionListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.timer = new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Motion2DPanel.this.stepInTime();
            }
        });
        this.timer.start();
        this.bothButton.doClick();
        Point point = new Point(20, this.yNow);
        this.wiggleMe = new WiggleMe(this, point, new Vector2D.Double(0.0, 1.0), 20.0, 5.0, SimStrings.getInstance().getString("Motion2DPanel.WiggleMeText"));
        this.wiggleMe.setCenter(point);
        this.wiggleMeTimer = new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Motion2DPanel.this.wiggleMe.stepInTime(0.01);
            }
        });
        this.wiggleMeTimer.start();
    }

    private void stepInTime() {
        if (this.motionPanel1.getMotionOnState()) {
            this.motionPanel1.nextPosition();
            this.setXYNow(this.motionPanel1.getXNow(), this.motionPanel1.getYNow());
        }
        this.motion2DModel.addPointAndUpdate(this.xNow, this.yNow);
        this.repaint();
    }

    private void setup(JRadioButton jRadioButton) {
        this.buttonGroup.add(jRadioButton);
        jRadioButton.setBackground(Color.orange);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paintComponent(graphics);
        this.avgXMid = (int)this.motion2DModel.getAvgXMid();
        this.avgYMid = (int)this.motion2DModel.getAvgYMid();
        this.xVel = (int)(this.velFactor / 2.0 * this.motion2DModel.getXVel());
        this.yVel = (int)(this.velFactor / 2.0 * this.motion2DModel.getYVel());
        double d = this.accFactor * this.motion2DModel.getXAcc();
        double d2 = this.accFactor * this.motion2DModel.getYAcc();
        graphics.drawImage(this.myGui.getBallImage(), this.avgXMid - this.radius, this.avgYMid - this.radius, 2 * this.radius, 2 * this.radius, this);
        if (this.buttonFlag != 4) {
            if (this.buttonFlag == 1) {
                graphics.setColor(this.myGreen);
                this.motion2DArrow.setPosition(this.avgXMid, this.avgYMid, this.avgXMid + this.xVel, this.avgYMid + this.yVel);
                this.motion2DArrow.paint(graphics);
            } else if (this.buttonFlag == 2) {
                graphics.setColor(Color.blue);
                this.motion2DArrow.setPosition(this.avgXMid, this.avgYMid, (double)this.avgXMid + d, (double)this.avgYMid + d2);
                this.motion2DArrow.paint(graphics);
            } else if (this.buttonFlag == 3) {
                graphics.setColor(this.myGreen);
                this.motion2DArrow.setPosition(this.avgXMid, this.avgYMid, this.avgXMid + this.xVel, this.avgYMid + this.yVel);
                this.motion2DArrow.paint(graphics);
                graphics.setColor(Color.blue);
                this.motion2DArrow.setPosition(this.avgXMid, this.avgYMid, (double)this.avgXMid + d, (double)this.avgYMid + d2);
                this.motion2DArrow.paint(graphics);
            }
        }
        if (this.wiggleMe != null) {
            this.wiggleMe.paint(graphics2D);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.vButton) {
            this.buttonFlag = 1;
        } else if (actionEvent.getSource() == this.aButton) {
            this.buttonFlag = 2;
        } else if (actionEvent.getSource() == this.bothButton) {
            this.buttonFlag = 3;
        } else if (actionEvent.getSource() == this.neitherButton) {
            this.buttonFlag = 4;
        } else if (actionEvent.getSource() == this.moreButton) {
            this.motion2DControlFrame.setVisible(true);
            this.moreButton.setEnabled(false);
            this.motion2DControlFrame.toFront();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.hideCursor();
        this.removeWiggler();
        this.setXYNow(mouseEvent.getX(), mouseEvent.getY());
    }

    private void removeWiggler() {
        if (this.wiggleMe != null) {
            this.wiggleMeTimer.stop();
            this.wiggleMe.setVisible(false);
            this.repaint(this.wiggleMe.getBounds());
            this.wiggleMe = null;
        }
    }

    private void hideCursor() {
        this.myGui.setCursor(this.myGui.hide);
    }

    private void showCursor() {
        this.myGui.setCursor(this.myGui.show);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point;
        Point point2 = mouseEvent.getPoint();
        double d = point2.distance(point = new Point(this.xNow, this.yNow));
        if (d < (double)this.myGui.getBallImage().getWidth(this) / 2.0) {
            this.myGui.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.myGui.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setXYNow(int n, int n2) {
        if (n != this.xNow || this.yNow != n2) {
            this.xNow = n;
            this.yNow = n2;
        }
    }

    public int getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(int n) {
        this.timeStep = n;
        this.motion2DControlFrame.getTimeStepBar().setValue(n);
        this.timer.setDelay(n);
    }

    public double getVelFactor() {
        return this.velFactor;
    }

    public void setVelFactor(double d) {
        this.velFactor = d;
        this.motion2DControlFrame.getVelFactorBar().setValue((int)d);
    }

    public double getAccFactor() {
        return this.accFactor;
    }

    public void setAccFactor(double d) {
        this.accFactor = d;
        this.motion2DControlFrame.getAccFactorBar().setValue((int)d);
    }

    public JButton getMoreButton() {
        return this.moreButton;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.showCursor();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.showCursor();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.showCursor();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showCursor();
    }
}

