/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motion2d;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.motion2d.Motion2DModel;
import edu.colorado.phet.motion2d.Motion2DPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MotionPanel
extends JPanel
implements ActionListener {
    private Motion2DPanel myJP;
    private JRadioButton constAIRadBtn;
    private JRadioButton constAIIRadBtn;
    private JRadioButton sHMRadBtn;
    private JRadioButton circularRadBtn;
    private JRadioButton stopRadBtn;
    private double amplitude;
    private double tNow;
    private boolean goingRight;
    private boolean motionOn;
    private int buttonFlag;
    private final int CONST_AI = 0;
    private final int CONST_AII = 1;
    private final int SHM = 2;
    private final int CIRCULAR = 3;
    private final int STOP = 4;
    private int xNow;
    private int yNow;
    private double xDoubleNow;
    private int width = -1;
    private int height = -1;

    public MotionPanel(final Motion2DPanel motion2DPanel, Motion2DModel motion2DModel, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.myJP = motion2DPanel;
        this.motionOn = false;
        this.setBackground(Color.orange);
        this.constAIRadBtn = new JRadioButton(SimStrings.getInstance().getString("MotionPanel.LinearAccIRadioButton"), false);
        this.constAIIRadBtn = new JRadioButton(SimStrings.getInstance().getString("MotionPanel.LinearAccIIRadioButton"), false);
        this.sHMRadBtn = new JRadioButton(SimStrings.getInstance().getString("MotionPanel.SimpleHarmonicRadioButton"), false);
        this.circularRadBtn = new JRadioButton(SimStrings.getInstance().getString("MotionPanel.CircularRadioButton"), false);
        this.stopRadBtn = new JRadioButton(SimStrings.getInstance().getString("MotionPanel.StopRadioButton"), true);
        this.constAIRadBtn.setBackground(Color.orange);
        this.constAIIRadBtn.setBackground(Color.orange);
        this.sHMRadBtn.setBackground(Color.orange);
        this.circularRadBtn.setBackground(Color.orange);
        this.stopRadBtn.setBackground(Color.orange);
        this.amplitude = 175.0;
        motion2DPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MotionPanel.this.width = motion2DPanel.getWidth();
                MotionPanel.this.height = motion2DPanel.getHeight();
            }
        });
    }

    public void launchMotionPanel() {
        this.constAIRadBtn.addActionListener(this);
        this.constAIIRadBtn.addActionListener(this);
        this.sHMRadBtn.addActionListener(this);
        this.circularRadBtn.addActionListener(this);
        this.stopRadBtn.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.constAIRadBtn);
        buttonGroup.add(this.constAIIRadBtn);
        buttonGroup.add(this.sHMRadBtn);
        buttonGroup.add(this.circularRadBtn);
        buttonGroup.add(this.stopRadBtn);
        this.add(this.constAIRadBtn);
        this.add(this.constAIIRadBtn);
        this.add(this.sHMRadBtn);
        this.add(this.circularRadBtn);
        this.add(this.stopRadBtn);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.constAIRadBtn.isSelected()) {
            this.buttonFlag = 0;
            this.motionOn = true;
            this.goingRight = true;
            this.yNow = this.height / 2;
            this.xDoubleNow = 0.0;
            this.tNow = 0.0;
            this.myJP.setTimeStep(35);
            this.myJP.setVelFactor(2.0);
            this.myJP.setAccFactor(6.0);
        }
        if (this.constAIIRadBtn.isSelected()) {
            this.buttonFlag = 1;
            this.motionOn = true;
            this.yNow = this.height / 2;
            this.xDoubleNow = 30.0;
            this.xNow = (int)this.xDoubleNow;
            this.tNow = 0.0;
            this.myJP.setTimeStep(35);
            this.myJP.setVelFactor(4.0);
            this.myJP.setAccFactor(13.0);
        }
        if (this.sHMRadBtn.isSelected()) {
            this.buttonFlag = 2;
            this.motionOn = true;
            this.tNow = 0.0;
            this.myJP.setTimeStep(35);
            this.myJP.setVelFactor(10.0);
            this.myJP.setAccFactor(17.0);
        }
        if (this.circularRadBtn.isSelected()) {
            this.myJP.setTimeStep(35);
            this.myJP.setVelFactor(4.0);
            this.myJP.setAccFactor(15.0);
            this.buttonFlag = 3;
            this.motionOn = true;
            this.tNow = 0.0;
            this.myJP.setTimeStep(35);
            this.myJP.setVelFactor(4.0);
            this.myJP.setAccFactor(15.0);
        }
        if (actionEvent.getSource() == this.stopRadBtn) {
            this.buttonFlag = 4;
            this.motionOn = false;
            this.myJP.setTimeStep(10);
            this.myJP.setVelFactor(4.0);
            this.myJP.setAccFactor(6.0);
            this.stopRadBtn.setSelected(true);
        }
    }

    public void nextPosition() {
        double d = 200.0;
        double d2 = 0.5;
        double d3 = 0.005;
        double d4 = 20.0;
        double d5 = d4 * d4 / (2.0 * (double)(9 * this.width / 10));
        switch (this.buttonFlag) {
            case 0: {
                if (this.goingRight && this.xNow < 9 * this.width / 10) {
                    this.xDoubleNow += d3 * this.tNow * this.tNow;
                    this.tNow += 1.0;
                } else if (this.xNow > 9 * this.width / 10 && this.goingRight) {
                    this.tNow -= 2.0;
                    if (this.tNow < 0.0) {
                        this.goingRight = false;
                    }
                } else if (!this.goingRight && this.xNow > this.width / 10) {
                    this.xDoubleNow -= d3 * this.tNow * this.tNow;
                    this.tNow += 1.0;
                } else if (this.xNow < this.width / 10 && !this.goingRight) {
                    this.tNow -= 2.0;
                    if (this.tNow < 0.0) {
                        this.goingRight = true;
                    }
                }
                this.xNow = (int)this.xDoubleNow;
                break;
            }
            case 1: {
                if (this.motionOn && this.xNow > 29) {
                    this.xDoubleNow = 31.0 + d4 * this.tNow - 0.5 * d5 * this.tNow * this.tNow;
                    this.xNow = (int)this.xDoubleNow;
                    this.tNow += 1.0;
                }
                if (!this.motionOn || this.xNow >= 29) break;
                this.motionOn = false;
                break;
            }
            case 2: {
                this.yNow = this.height / 2;
                this.tNow += 1.0;
                this.xNow = this.width / 2 + (int)(this.amplitude * Math.sin(Math.PI * 2 * this.tNow / d));
                break;
            }
            case 3: {
                this.tNow += 1.0;
                this.xNow = this.width / 2 + (int)(this.amplitude * Math.cos(Math.PI * 2 * this.tNow / d));
                this.yNow = this.height / 2 + (int)(this.amplitude * Math.sin(Math.PI * 2 * this.tNow / d));
            }
        }
    }

    public boolean getMotionOnState() {
        return this.motionOn;
    }

    public int getXNow() {
        return this.xNow;
    }

    public int getYNow() {
        return this.yNow;
    }
}

